# PHP eBay API

Schnittstelle für eBay über PHP.

## Wo finde ich die eBay Keys?

### Key Erklärung - setting/config = eBay Betitelung

- SECURITY-APPNAME = `App ID`
- DEV-NAME = `Dev ID`
- CERT-NAME = `Cert ID`
- userToken = ``

### Wo ist welcher Key bei eBay zu finden

- `App ID`, `Dev ID` und `Cert ID` sind direkt unter `https://developer.ebay.com/my/keys` zu finden.
- oauthUserToken sind unter `https://developer.ebay.com/my/keys` zu finden aber unter dem Link `User Tokens`. Hier muss
  man sich dann unter *Get a User Token Here* einen Token anlegen
- userToken sind unter `https://developer.ebay.com/my/keys` zu finden. Bei der APP ID gibt es ein User Token Link. 
Hier kannst du ein OAuth User Token generieren. Dazu musst du bei "Get a User Token Here" OAuth generieren.

## Wichtig Links

- https://developer.ebay.com/signin
- https://developer.ebay.com/develop/get-started/api-call-limits

## Benötigt php-apc Paket

Falls nicht vorhanden in `Ebay.php` sämtliche `$driver = new Apc();` durch `$driver = new FileSystem();` ersetzen;

## Default Werte sind

```
    'SECURITY-APPNAME' => '',
    'CERT-NAME' => '',
    'DEV-NAME' => '',
    
    'GLOBAL-ID' => 'EBAY-DE',
    'SERVICE-VERSION'  '1.11.0',
    'REST-PAYLOAD' => '',

    'affiliate.networkId' => 9,
    'affiliate.trackingId' => '5336210971',
    'affiliate.customId' => '5336210971'
```

## Verwendung

```php
<?php

$Ebay = new \PCSG\API\Ebay([
    'SECURITY-APPNAME' => $appId,
    'CERT-NAME' => $certId,
    'DEV-NAME' => $devId,
    'GLOBAL-ID' => 'EBAY-DE',
    'sandbox' => true  
]);

?>
```

Per setAttribute() oder während der Initialisierung können alle eBay Attribute gesetzt werden.
Zum Beispiel paginationInput.entriesPerPage = 10

```php

<?php

$Ebay = new \PCSG\API\Ebay([
    'SECURITY-APPNAME' => $appId,
    'CERT-NAME' => $certId,
    'DEV-NAME' => $devId,
    'GLOBAL-ID' => 'EBAY-DE',
    'sandbox' => true  
    
    'paginationInput.entriesPerPage' => 20,
    'keywords' => 'lenovo'
]);

?>

```

```php

<?php

$Ebay->setAttribute('paginationInput.entriesPerPage', 20);
$Ebay->setAttribute('keywords', 'lenovo');

?>

```

### Ebay Search

```php

<?php

$Ebay->setAttribute('keywords', 'lenovo');
$result = $Ebay->search();

?>

```

### Advanced Ebay Search

```php

<?php

$Ebay = new \PCSG\API\Ebay([
    'SECURITY-APPNAME' => $appId,
    'CERT-NAME' => $certId,
    'DEV-NAME' => $devId,
    'GLOBAL-ID' => 'EBAY-DE',
    'sandbox' => true  
 
    'keywords' => 'computer',
    'itemFilter(0).name' => 'MaxPrice',
    'itemFilter(0).value' => 25,
    'itemFilter(0).paramName' => 'Currency',
    'itemFilter(0).paramValue' => 'USD',
    'itemFilter(1).name' => 'FreeShippingOnly',
    'itemFilter(1).value' => 'true',
    'itemFilter(2).name' => 'ListingType',
    'itemFilter(2).value(0)' => 'AuctionWithBIN',
    'itemFilter(2).value(1)' => 'FixedPrice',
    'itemFilter(2).value(2)' => 'StoreInventory',
    'paginationInput.entriesPerPage' => 2
]);

$result = $Ebay->search();

?>

```

### Affiliate parameter

```php

<?php

$Ebay = new \PCSG\API\Ebay([
    'SECURITY-APPNAME' => 'APP_NAME',
    'affiliate.networkId'  => 9,
    'affiliate.trackingId' => '5336210971',
    'affiliate.customId' => '5336210971'
]);

$result = $Ebay->getItemsBySeller('ebay_seller_name');

?>

```

### Affiliate the old Way, works, too

```php

<?php

$Ebay = new \PCSG\API\Ebay([
    'SECURITY-APPNAME'    => 'APP_NAME',
    'trackingId'          => 9,
    'affiliateUserId'     => '5336210971',
    'trackingPartnercode' => '5336210971'
]);

$result = $Ebay->getItemsBySeller('ebay_seller_name');

?>

```
