/**
 * @module package/quiqqer/adblock-detection/bin/detection
 */
define('package/quiqqer/adblock-detection/bin/detection', [

    'Locale',

    'css!package/quiqqer/adblock-detection/bin/detection.css'

], function (QUILocale) {
    "use strict";

    const lg = 'quiqqer/adblock-detection';
    let canRunAds = null;

    return {

        /**
         * parse all add places and fill it with add block detection
         */
        parse: function () {
            const self = this;
            const elements = document.querySelectorAll('[data-ad-detection]');

            this.canRunAds().then(function (canRun) {
                if (canRun) {
                    return;
                }

                elements.forEach(function (elm) {
                    const Hint = self.createHint();

                    elm.appendChild(Hint);

                    if (elm.nodeName === 'BODY') {
                        Hint.classList.add('body-ad-detection');
                        return;
                    }

                    elm.style.position = 'relative';

                    const size = elm.getSize();

                    if (size.x < 400 || size.y < 150) {
                        elm.classList.add('ad-detection-container--no-icon');
                    }
                });
            });
        },

        /**
         * Add block on or off?
         *
         * @return {Promise}
         */
        canRunAds: function () {
            if (canRunAds !== null) {
                return Promise.resolve(canRunAds);
            }

            const self = this;

            return new Promise(function (resolve) {
                try {
                    fetch("https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js", {
                        method: 'HEAD',
                        mode: 'no-cors'
                    }).then(function () {
                        console.log('[OK] Google Ads Test: Google');

                        canRunAds = true;
                        resolve(canRunAds);
                    }).catch(function () {
                        console.log('[FALSE] Google Ads Test: Google');

                        canRunAds = false;
                        resolve(canRunAds);
                    });
                } catch (e) {
                    console.warn('AdBlock Test - Could not test via adsbygoogle', e);
                    self.testViaAdsJs().then(resolve);
                }
            });
        },

        /**
         * test via own ads.js file
         *
         * @return {*}
         */
        testViaAdsJs: function () {
            return new Promise(function (resolve) {
                try {
                    require(['package/quiqqer/adblock-detection/bin/ads'], function (ads) {
                        canRunAds = ads();
                        resolve(canRunAds);
                    }, function () {
                        canRunAds = false;
                        resolve(canRunAds);
                    });
                } catch (e) {
                    canRunAds = false;
                    resolve(canRunAds);
                }
            });
        },

        /**
         * Create a ad detection hint
         *
         * @return {HTMLDivElement}
         */
        createHint: function () {
            const Hint = document.createElement('section');
            Hint.classList.add('ad-detection');

            const Container = document.createElement('div');
            Container.classList.add('ad-detection-container');
            Hint.appendChild(Container);

            const Icon = document.createElement('span');
            Icon.classList.add('ad-detection-container-icon');
            Icon.classList.add('fa');
            Icon.classList.add('fa-ban');
            Container.appendChild(Icon);

            const Text = document.createElement('div');
            Text.classList.add('ad-detection-container-text');
            Text.innerHTML = QUILocale.get(lg, 'adblock.message');
            Container.appendChild(Text);

            return Hint;
        }
    };
});

require(['package/quiqqer/adblock-detection/bin/detection'], function (Detection) {
    "use strict";
    Detection.parse();
});
