# MCP (ModelContextProtocol)

## What is MCP?

**MCP** stands for **Model Context Protocol**. It is an open, standardized protocol designed to enable AI models to
interact with external systems like QUIQQER in a secure, structured, and extensible way. The QUIQQER AI MCP Server
implements this protocol, providing a REST API that allows AI models to generate content (text, images, videos, etc.)
and to access additional tools and endpoints provided by QUIQQER modules.

MCP makes it possible for AI models and QUIQQER modules to communicate seamlessly. Modules can register their own AI
tools as MCP endpoints, making their functionality available to AI models and external clients via the MCP interface.

## What can you do with MCP?

- **Register AI tools:** QUIQQER modules and plugins can register their own MCP endpoints (tools) for use by AI models.
- **Discover tools:** Clients and AI models can query the MCP server to discover available tools, their parameters, and
  descriptions.
- **Execute tools:** Tools can be executed securely via the MCP REST API, enabling automation, integration, and
  cross-module workflows.
- **Parameter validation:** The MCP server handles parameter types, validation, and documentation automatically.

## Typical Use Cases

- Exposing AI, automation, or batch processing capabilities via standard endpoints
- Integrating external AI services or APIs in a unified way
- Building custom AI-powered workflows that orchestrate multiple QUIQQER modules
- Providing AI-driven automation steps and business logic

## How does it work?

1. **Providers:** QUIQQER modules define "providers" that register one or more tools (endpoints) with the MCP server.
2. **Tools:** Each tool describes its name, description, parameters, and execution logic.
3. **Registration:** Providers are registered via the module's `package.xml` file.
4. **API:** The MCP server exposes a REST API for listing and executing tools, protected by an API key.

---

## Next Steps

- [How to Create an MCP Tool in Your Module/Plugin](how_to_create_an_mcp_tool.md)

Read the guide above to learn how to implement and register your own MCP tools in QUIQQER.
