<?php

namespace QUI\AI\MCP;

use Psr\Http\Message\ResponseInterface;
use OAuth2;
use QUI;
use Mcp;

class EventHandler
{
    public static function onRequest(QUI\Rewrite $rewrite, string $url): void
    {
        if ($url === 'mcp' || $url === 'mcp/') {
            $response = Server::run();

            if ($response instanceof ResponseInterface) {
                http_response_code($response->getStatusCode());
                foreach ($response->getHeaders() as $name => $values) {
                    foreach ($values as $value) {
                        header("$name: $value", false);
                    }
                }

                echo $response->getBody();
            } else {
                echo $response;
            }

            exit;
        }

        if ($url === 'authorize') {
            // @todo muss nachgereicht werden da im oauth etwas chaos ist
            exit;
        }

        if ($url === 'callback') {
            // @todo muss nachgereicht werden da im oauth etwas chaos ist
            exit;
        }

        if ($url === 'token') {
            $OAuth2Server = QUI\OAuth\Server::getInstance()->getOAuth2Server();
            $OAuthResponse = $OAuth2Server->handleTokenRequest(OAuth2\Request::createFromGlobals());

            // Sende die Antwort als JSON
            $statusCode = 200;

            if (method_exists($OAuthResponse, 'getStatusCode')) {
                $statusCode = $OAuthResponse->getStatusCode();
            }

            header('Content-Type: application/json', true, $statusCode);

            if (method_exists($OAuthResponse, 'getResponseBody')) {
                echo $OAuthResponse->getResponseBody();
                exit;
            }

            if (method_exists($OAuthResponse, 'getBody')) {
                echo $OAuthResponse->getBody();
                exit;
            }

            exit;
        }
    }

    public static function onQuiqqerMcpInit(Mcp\Server\Builder $server): void
    {
    }
}
