<?php

namespace QUI\AI\MCP;

use Mcp;
use Mcp\Server\Builder;

class McpProvider implements ProviderInterface
{
    public function register(Builder $serverBuilder): void
    {
        // examples

        // hello world / MCP
        $serverBuilder->addTool(
        // @phpstan-ignore-next-line
            function (): Mcp\Schema\Result\CallToolResult | string {
                try {
                    /*
                    QUI\Permissions\Permission::checkPermission(
                        'quiqqer.ai.mcp',
                        Server::getRequestUser()
                    );
                    */

                    return 'Hello MCP';
                    // @phpstan-ignore-next-line
                } catch (\Exception $e) {
                    return ToolHelper::parseExceptionToResult($e);
                }
            },
            name: 'hello',
            description: 'Returns a hello message from the MCP server'
        );


        // calculator
        $serverBuilder->addTool(
            function (float $a, float $b, string $operation = 'add'): array {
                $result = match ($operation) {
                    'add' => $a + $b,
                    'subtract' => $a - $b,
                    'multiply' => $a * $b,
                    'divide' => 0 != $b ? $a / $b : throw new Mcp\Exception\InvalidArgumentException(
                        'Cannot divide by zero'
                    ),
                    default => throw new Mcp\Exception\InvalidArgumentException("Unknown operation: {$operation}"),
                };

                return [
                    'operation' => $operation,
                    'operands' => [$a, $b],
                    'result' => $result,
                ];
            },
            name: 'calculator',
            description: 'Perform basic math operations (add, subtract, multiply, divide)'
        );
    }
}
