<?php

namespace QUI\AI\MCP;

use QUI;
use Mcp\Schema\Result\CallToolResult;
use Mcp\Schema\Content\TextContent;

class ToolHelper
{
    public static function parseExceptionToResult(mixed $e): CallToolResult
    {
        if ($e instanceof QUI\Permissions\Exception) {
            return CallToolResult::error([
                new TextContent('permission_denied: ' . $e->getMessage())
            ]);
        }

        if ($e instanceof QUI\Exception) {
            return CallToolResult::error([
                new TextContent('internal_error: ' . $e->getMessage())
            ]);
        }

        // Fallback für alles andere
        if ($e instanceof \Throwable) {
            QUI\System\Log::addError($e->getMessage());
            return CallToolResult::error([
                new TextContent('internal_error: Internal server error')
            ]);
        }

        return CallToolResult::error([
            new TextContent('internal_error: Internal server error')
        ]);
    }
}
