<?php

define('QUIQQER_SYSTEM', true);
require_once dirname(__DIR__, 7) . '/header.php';
chdir(__DIR__);

if (PHP_SAPI !== 'cli') {
    exit;
}

error_reporting(E_ALL & ~E_DEPRECATED);
ini_set('display_errors', 1);

use GuzzleHttp\Client;
use GuzzleHttp\Handler\CurlHandler;
use GuzzleHttp\HandlerStack;

$endpoint = HOST . '/mcp';

$stack = HandlerStack::create(new CurlHandler());
$client = new Client([
    'base_uri' => $endpoint,
    'handler' => $stack,

    // ... weitere Optionen ...
    'http_errors' => false,
    'headers' => [
        'Content-Type' => 'application/json',
        'Accept' => 'application/json, text/event-stream',
    ],
    'stream' => true,
    'verify' => true,
    'timeout' => 60,
    'connect_timeout' => 30,
    'version' => 2.0, // HTTP/2
]);

/**
 * @param Client $client
 * @param array<string, mixed> $body
 * @param array<string, mixed> $addHeaders
 * @return string|null
 */
function guzzle(Client $client, array $body, array $addHeaders = []): null | string
{
    $response = $client->post('', [
        'headers' => $addHeaders,
        'body' => json_encode($body)
    ]);

    if ($response->getStatusCode() !== 200) {
        echo "HTTP-Code: " . $response->getStatusCode() . "\n";
        echo $response->getBody()->getContents();
        return null;
    }

    return $response->getBody()->getContents();
}

// 1. Session initialisieren
$protocolVersion = '2025-06-18';
$initBody = [
    'jsonrpc' => '2.0',
    'id' => '1',
    'method' => 'initialize',
    'params' => [
        'protocolVersion' => $protocolVersion,
        'clientInfo' => [
            'name' => 'mcp-client',
            'version' => '1.0.0'
        ],
        'capabilities' => new stdClass()
    ]
];

$response = $client->post('', [
    'headers' => [
        'Content-Type' => 'application/json',
        'Accept' => 'application/json'
    ],
    'body' => json_encode($initBody)
]);

$headers = $response->getHeaders();
$sessionId = null;

if (isset($headers['mcp-session-id'][0])) {
    $sessionId = $headers['mcp-session-id'][0];
}

if (!$sessionId) {
    die("Fehler: Keine Session-ID erhalten\n");
}

$headers = [
    'Mcp-Session-Id' => $sessionId,
    'Mcp-Protocol-Version' => $protocolVersion
];

// 2. Tool-Call: "hello"
echo PHP_EOL . "Antwort vom MCP-Server:" . PHP_EOL;

echo guzzle(
    $client,
    [
        'jsonrpc' => '2.0',
        'id' => '2',
        'method' => 'tools/call',
        'params' => [
            'session_id' => $sessionId,
            'name' => 'hello',
            'params' => []
        ]
    ],
    $headers
);


// 3. Tool-Call: "calculator"
echo PHP_EOL . PHP_EOL . "Calculator-Ergebnis:" . PHP_EOL;

echo guzzle(
    $client,
    [
        'jsonrpc' => '2.0',
        'id' => '3',
        'method' => 'tools/call',
        'params' => [
            'session_id' => $sessionId,
            'name' => 'calculator',
            "arguments" => [
                'a' => 7,
                'b' => 3,
                'operation' => 'multiply'
            ]
        ]
    ],
    $headers
);

echo PHP_EOL;
echo PHP_EOL;
