<?php

/**
 * This file contains QUI\FrontendUsers\Controls\Profile\ControlWrapper
 */

namespace QUI\Captcha\Modules\Google;

use QUI;
use QUI\Captcha\Modules\Google;
use QUI\Exception;

/**
 * Class Controls
 *
 * Google reCAPTCHA Control
 */
class Control extends QUI\Captcha\Controls\CaptchaControl
{
    /**
     * ControlWrapper constructor.
     * @param array $attributes
     * @throws Exception
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->addCSSClass('quiqqer-captcha-google');

        $this->setJavaScriptControl('package/quiqqer/captcha/bin/controls/modules/Google');
        $this->setJavaScriptControlOption('sitekey', Google::getSiteKey());

        $this->addCSSFile(dirname(__FILE__) . '/Control.css');
    }

    /**
     * @return string
     */
    public function getBody(): string
    {
        $Engine = QUI::getTemplateManager()->getEngine();
        return $Engine->fetch(dirname(__FILE__) . '/Control.html');
    }
}
