<?php

namespace QUI\Captcha\Modules;

use Exception;
use QUI;
use QUI\Captcha\Modules\SimpleMath\Control;

use function mt_rand;
use function random_int;

/**
 * Simple math problem (e.g. "3 x 3 = 9")
 */
class SimpleMath extends QUI\Captcha\AbstractCaptcha
{
    const SESSION_KEY_SIMPLE_MATH_PROBLEM = 'quiqqer_captcha__simple-math';

    /**
     * Get control to show captcha
     *
     * @return Control
     */
    public static function getControl(): QUI\Control
    {
        return new Control();
    }

    /**
     * Validate captcha data
     *
     * @param string $data
     * @return bool
     */
    public static function isValid(string $data): bool
    {
        $problem = QUI::getSession()->get(self::SESSION_KEY_SIMPLE_MATH_PROBLEM);

        if (empty($problem)) {
            return false;
        }

        return (int)$problem['a'] * (int)$problem['b'] === (int)$data;
    }

    /**
     * Generate random simple math problem and save it in the session.
     *
     * @return array
     */
    public static function generateMathProblem(): array
    {
        try {
            $a = random_int(1, 9);
        } catch (Exception $Exception) {
            QUI\System\Log::writeException($Exception);
            $a = mt_rand(1, 9);
        }

        try {
            $b = random_int(1, 9);
        } catch (Exception $Exception) {
            QUI\System\Log::writeException($Exception);
            $b = mt_rand(1, 9);
        }

        $problem = ['a' => $a, 'b' => $b];

        QUI::getSession()->set(self::SESSION_KEY_SIMPLE_MATH_PROBLEM, $problem);

        return $problem;
    }

    /**
     * Does this Captcha module require JavaScript?
     *
     * @return bool
     */
    public static function requiresJavaScript(): bool
    {
        return false;
    }
}
