<?php

namespace QUI\Captcha\Modules\SimpleMath;

use QUI;

use function dirname;

/**
 * Class Controls
 *
 * Google reCAPTCHA Control
 */
class Control extends QUI\Captcha\Controls\CaptchaControl
{
    /**
     * ControlWrapper constructor.
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->addCSSClass('quiqqer-captcha-simplemath');
        $this->addCSSFile(dirname(__FILE__) . '/Control.css');
    }

    /**
     * @return string
     */
    public function getBody(): string
    {
        $Engine = QUI::getTemplateManager()->getEngine();

        $Engine->assign([
            'problem' => QUI\Captcha\Modules\SimpleMath::generateMathProblem()
        ]);

        return $Engine->fetch(dirname(__FILE__) . '/Control.html');
    }
}
