<?php

namespace QUI\Captcha;

use QUI\Control;
use QUI\Locale;

interface CaptchaInterface
{
    /**
     * Get control to show captcha
     *
     * @return Control
     */
    public static function getControl(): Control;

    /**
     * Validate captcha data
     *
     * @param string $data
     * @return bool
     */
    public static function isValid(string $data): bool;

    /**
     * Get Captcha module title
     *
     * @param Locale|null $Locale (optional) - if omitted use \QUI::getLocale()
     * @return string
     */
    public static function getTitle(?Locale $Locale = null): string;

    /**
     * Get Captcha module description
     *
     * @param Locale|null $Locale (optional) - if omitted use \QUI::getLocale()
     * @return string
     */
    public static function getDescription(?Locale $Locale = null): string;

    /**
     * Get Captcha module name
     *
     * @return string
     */
    public static function getModuleName(): string;

    /**
     * Does this Captcha module require JavaScript?
     *
     * @return bool
     */
    public static function requiresJavaScript(): bool;

    /**
     * Check if this CAPTCHA has a visible representation or not
     *
     * @return bool
     */
    public static function isInvisible(): bool;
}
