<?php

/**
 * This file contains QUI\Captcha\Controls\CaptchaDisplay
 */

namespace QUI\Captcha\Controls;

use QUI;
use QUI\Captcha\Handler;
use QUI\Exception;

/**
 * Class CaptchaDisplay
 *
 * Displays CAPTCHA
 */
class CaptchaDisplay extends QUI\Control
{
    /**
     * ControlWrapper constructor.
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->addCSSClass('quiqqer-captcha-display');
        $this->setJavaScriptControl('package/quiqqer/captcha/bin/controls/CaptchaDisplay');
        $this->setJavaScriptControlOption('module_has_js_control', Handler::requiresJavaScript());
    }

    /**
     * @return string
     * @throws Exception
     */
    public function getBody(): string
    {
        $Engine = QUI::getTemplateManager()->getEngine();

        $Engine->assign([
            'ModuleControl' => Handler::getDefaultCaptchaModuleControl()
        ]);

        return $Engine->fetch(dirname(__FILE__) . '/CaptchaDisplay.html');
    }

    /**
     * Check if this CAPTCHA has a visible representation or not
     *
     * @return bool
     */
    public function isInvisible(): bool
    {
        return Handler::isInvisible();
    }
}
