<?php

/**
 * @author PCSG (Jan Wennrich)
 */

namespace QUI\Captcha\Cookies;

use QUI;
use QUI\GDPR\CookieInterface;

use function sprintf;

/**
 * Class QuiqqerSessionCookie
 *
 * @package QUI\GDPR\Cookies
 */
class GoogleRecaptchaCookie implements CookieInterface
{
    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return '_GRECAPTCHA';
    }

    /**
     * @inheritDoc
     */
    public function getOrigin(): string
    {
        return 'https://www.google.com';
    }

    /**
     * @inheritDoc
     */
    public function getPurpose(): string
    {
        return QUI::getLocale()->get('quiqqer/captcha', 'cookie.google.recaptcha.purpose');
    }

    /**
     * @inheritDoc
     */
    public function getLifetime(): string
    {
        return sprintf(
            '%d %s',
            180,
            QUI::getLocale()->get('quiqqer/core', 'days')
        );
    }

    /**
     * @inheritDoc
     */
    public function getCategory(): string
    {
        return static::COOKIE_CATEGORY_STATISTICS;
    }
}
