(function () {
    "use strict";
    console.log('init quiqqer bricks');
    // finds out which project are active
    const getProjectData = function (Node, editor) {
        let Panel, Site;
        let project = '';
        let lang = '';

        if (Node.closest('.qui-panel')) {
            Panel = window.QUI.Controls.getById(
                Node.closest('.qui-panel').get('data-quiid')
            );

            if (Panel && Panel.getType() === 'controls/projects/project/site/Panel') {
                Site = Panel.getSite();

                project = Site.getProject().getName();
                lang = Site.getProject().getLang();
            }
        } else {
            Node = editor.ui.contentsElement.$;

            if (Node.closest('.qui-panel')) {
                Panel = window.QUI.Controls.getById(
                    Node.closest('.qui-panel').get('data-quiid')
                );

                if (Panel && Panel.getType() === 'controls/projects/project/site/Panel') {
                    Site = Panel.getSite();

                    project = Site.getProject().getName();
                    lang = Site.getProject().getLang();
                }
            }
        }

        return {
            project: project,
            lang   : lang
        };
    };

    const editNode = function (Node, editor) {
        if (!Node.classList.contains('quiqqer_bricks_placeholder')) {
            return;
        }

        const brickId = Node.getAttribute('data-brickid');
        const projectData = getProjectData(Node, editor);

        require([
            'Locale',
            'qui/controls/windows/Confirm'
        ], function (QUILocale, QUIConfirm) {
            new QUIConfirm({
                icon     : 'fa fa-cubes',
                title    : QUILocale.get('quiqqer/ckeditor4', 'window.bricks.editor.edit.title'),
                maxHeight: 300,
                maxWidth : 500,
                events   : {
                    onOpen: function (Win) {
                        Win.getContent().set(
                            'html',

                            '<label style="display: flex; width: 350px; margin: 2rem auto 0;">' +
                            '   <span style="padding: 0 10px 0 0; line-height: 30px;">Brick ID:</span>' +
                            '   <input style="flex-grow: 1" type="text" name="brickId" />' +
                            '   <button class="qui-button" name="select">' +
                            '       <span class="fa fa-cubes"></span>' +
                            '   </button>' +
                            '   <button class="qui-button" name="edit">' +
                            '       <span class="fa fa-edit"></span>' +
                            '   </button>' +
                            '</label>'
                        );

                        Win.getContent().getElement('input').set('value', brickId);
                        Win.getContent().getElement('button[name="select"]').set(
                            'title',
                            QUILocale.get('quiqqer/ckeditor4', 'window.bricks.editor.selectBrick')
                        );

                        Win.getContent().getElement('button[name="edit"]').set(
                            'title',
                            QUILocale.get('quiqqer/ckeditor4', 'window.bricks.editor.editBrick')
                        );

                        Win.getContent().getElement('button[name="select"]').addEvent('click', function () {
                            require([
                                'package/quiqqer/bricks/bin/Controls/backend/BrickSelectWindow'
                            ], function (BrickSelectWindow) {
                                new BrickSelectWindow({
                                    project : projectData.project,
                                    lang    : projectData.lang,
                                    multiple: false,
                                    events  : {
                                        onSubmit: function (Instance, ids) {
                                            if (ids.length) {
                                                Win.getContent()
                                                   .getElement('input')
                                                   .set('value', parseInt(ids[0].id));
                                            }
                                        }
                                    }
                                }).open();
                            });
                        });

                        Win.getContent().getElement('button[name="edit"]').addEvent('click', function () {
                            let brickId = Win.getContent().getElement('input').value;

                            if (brickId === '') {
                                return;
                            }

                            Win.close();

                            require([
                                'utils/Panels',
                                'package/quiqqer/bricks/bin/BrickEdit'
                            ], function (PanelUtils, BrickPanel) {
                                PanelUtils.openPanelInTasks(
                                    new BrickPanel({
                                        id         : brickId,
                                        projectName: projectData.project,
                                        projectLang: projectData.lang
                                    })
                                );
                            });
                        });
                    },

                    onSubmit: function (Win) {
                        const brickId = Win.getContent().getElement('input').value;

                        if (brickId !== '') {
                            Node.setAttribute('data-brickid', brickId);
                            refreshPlaceholderDisplay(Node, editor);
                        }
                    }
                }
            }).open();
        });
    };

    // set custom div events
    const setPlaceHolderEvents = function (element, editor) {
        if (element.getAttribute('data-placeholder-event')) {
            return;
        }

        // edit
        element.addEventListener('click', function (e) {
            const Target = e.target;
            let Brick = Target;

            if (!Brick.classList.contains('quiqqer_bricks_placeholder')) {
                Brick = Target.closest('.quiqqer_bricks_placeholder');
            }

            // delete brick
            if (Target.name === 'delete') {
                e.preventDefault();
                Brick.parentNode.removeChild(Brick);
            }
        });

        element.addEventListener('dblclick', function (e) {
            editNode(e.target, editor);
        });

        element.setAttribute('data-placeholder-event', 1);
        element.setAttribute('tabindex', -1);

        refreshPlaceholderDisplay(element, editor);
    };

    // refresh placeholder display data
    const refreshPlaceholderDisplay = function (element, editor) {
        const doc = editor.document.$;
        let Info = element.querySelector('.quiqqer_bricks_placeholder_info');
        let Settings = element.querySelector('.quiqqer_bricks_placeholder_settings');

        if (!Info) {
            Info = doc.createElement('div');
            Info.classList.add('quiqqer_bricks_placeholder_info');
            Info.contentEditable = false;

            element.appendChild(Info);
        }

        if (!Settings) {
            Settings = doc.createElement('div');
            Settings.innerHTML = '<button name="delete">x</button>';
            Settings.contentEditable = false;

            Settings.classList.add('quiqqer_bricks_placeholder_settings');
            element.appendChild(Settings);
        }

        require(['Ajax'], function (QUIAjax) {
            QUIAjax.get('package_quiqqer_ckeditor4_ajax_getBrickInfo', function (result) {
                Info.innerHTML = result;
            }, {
                'package': 'quiqqer/ckeditor4',
                brickId  : element.getAttribute('data-brickid')
            });
        });
    };

    const setCustomEvents = function (evt) {
        const editor = evt.editor;
        const doc = editor.document.$;
        const elements = doc.querySelectorAll('.quiqqer_bricks_placeholder');

        for (let i = 0, len = elements.length; i < len; i++) {
            setPlaceHolderEvents(elements[i], editor);
        }
    };

    // add ckeditor
    window.CKEDITOR.plugins.add('quiqqerBricks', {
        icons: "icon",
        lang : [
            'en',
            'de'
        ],

        onLoad: function () {
            console.log('onload quiqqer bricks');
            // Register styles for placeholder widget frame.
            window.CKEDITOR.addCss(
                '.quiqqer_bricks_placeholder {' +
                '   cursor: pointer;' +
                '   display: inline-block;' +
                '   background-color:#dedede;' +
                '   height: 200px;' +
                '   margin-bottom: 10px;' +
                '   position: relative;' +
                '   width: 100%;' +
                '}' +
                '.quiqqer_bricks_placeholder:hover {' +
                '   outline: 2px solid #2F8FC6' +
                '}' +
                '.quiqqer_bricks_placeholder_info {' +
                '   left: 10px;' +
                '   position: absolute;' +
                '   pointer-events: none;' +
                '   top: 10px;' +
                '   user-select: none;' +
                '   -webkit-user-select:none;' +
                '   -moz-user-select:none;' +
                '}' +
                '' +
                '.quiqqer_bricks_placeholder_settings {' +
                '   display: none;' +
                //'   pointer-events: none;' +
                '   position: absolute;' +
                '   top: 10px;' +
                '   right: 10px;' +
                '}' +
                '' +
                '.quiqqer_bricks_placeholder:hover .quiqqer_bricks_placeholder_settings {' +
                '   display: inline;' +
                '}'
            );
        },

        init: function (editor) {
            console.log('on init quiqqer bricks');

            const self = this;

            this.$Editor = editor;

            editor.ui.addButton('QuiqqerBricks', {
                label  : editor.lang.quiqqerBricks.button,
                toolbar: 'insert',
                command: 'insert-quiqqer-brick',
                icon   : this.path + 'images/icon.png'
            });

            // save
            editor.on('getData', function (evt) {
                const Ghost = new Element('div', {
                    html: evt.data.dataValue
                });

                const placeholders = Ghost.getElements('.quiqqer_bricks_placeholder');
                let brickId, textNode, PH;

                if (!placeholders.length) {
                    return;
                }

                for (let i = 0, len = placeholders.length; i < len; i++) {
                    PH = placeholders[i];
                    brickId = PH.get('data-brickid');

                    if (!brickId) {
                        continue;
                    }

                    textNode = document.createTextNode("{{brick id=" + brickId + "}}");

                    PH.parentNode.insertBefore(textNode, PH);
                    PH.parentNode.removeChild(PH);
                }

                evt.data.dataValue = Ghost.get('html');
            });

            // load
            editor.on('setData', function (evt) {
                let result;
                const data = evt.data.dataValue;

                if (!data) {
                    return;
                }

                if (data.indexOf('{{brick ') === -1) {
                    return;
                }

                result = data.replace(
                    /{{brick ([^}}]*)}}/g,
                    function (match) {
                        match = match.replace('{{brick ', '');
                        match = match.replace('}}', '');
                        match = match.trim();
                        match = match.split(' ');

                        let parts;
                        const attributes = [];

                        for (let m = 0, len = match.length; m < len; m++) {
                            parts = match[m].trim().split('=');

                            attributes[parts[0]] = parts[1];
                        }

                        if ("id" in attributes) {
                            return '<cke:object ' +
                                   'contenteditable="false" ' +
                                   'data-cke-widget-wrapper="1" ' +
                                   'class="quiqqer_bricks_placeholder cke_widget_wrapper cke_widget_inline" ' +
                                   'data-brickid="' + attributes.id + '"' +
                                   '></cke:object>';
                        }

                        return "";
                    }
                );

                evt.data.dataValue = result;

                setTimeout(function () {
                    setCustomEvents(evt);
                }, 500);
            });

            editor.on('afterInsertHtml', setCustomEvents);


            // editor inser command
            editor.addCommand('insert-quiqqer-brick', {
                exec: function (editor) {
                    require([
                        'package/quiqqer/bricks/bin/Controls/backend/BrickSelectWindow'
                    ], function (BrickSelectWindow) {
                        // get project, if editor is in panel
                        const Node = editor.ui.contentsElement.$;
                        const projectData = getProjectData(Node, editor);

                        new BrickSelectWindow({
                            project : projectData.project,
                            lang    : projectData.lang,
                            area    : 'content',
                            multiple: false,
                            events  : {
                                onSubmit: function (Instance, bricks) {
                                    self.insertBrick(
                                        editor,
                                        bricks[0].id,
                                        bricks[0].project,
                                        bricks[0].lang
                                    );
                                }
                            }
                        }).open();
                    });
                }
            });
        },

        insertBrick: function (editor, brickId) {
            editor.insertHtml(
                '<div class="quiqqer_bricks_placeholder" ' +
                '   data-brickid="' + brickId + '"' +
                '>&nbsp;</div>' +
                '<p>&nbsp;</p>'
            );

            let i, len, o;
            const doc = editor.document.$;
            const nodes = doc.body.querySelectorAll('div.quiqqer_bricks_placeholder');

            for (i = 0, len = nodes.length; i < len; i++) {
                o = doc.createElement('cke:object');
                o.setAttribute('data-brickid', nodes[i].getAttribute('data-brickid'));
                o.setAttribute('data-cke-widget-wrapper', 1);

                o.classList.add('quiqqer_bricks_placeholder');
                o.classList.add('cke_widget_wrapper');
                o.classList.add('cke_widget_inline');
                o.contenteditable = false;

                nodes[i].parentNode.replaceChild(o, nodes[i]);
            }

            setCustomEvents({
                editor: editor
            });
        }
    });
})();
