<?php

/**
 * Return the rewritten url from an image.php url
 *
 * @param string $fileurl - image.php string
 *
 * @return string
 */

QUI::$Ajax->registerFunction(
    'ajax_media_url_rewrited',
    static function ($fileurl, $params) {
        if (QUI\Projects\Media\Utils::isMediaUrl($fileurl) === false) {
            return $fileurl;
        }

        if (!isset($params)) {
            $params = [];
        } else {
            $params = json_decode($params, true);
        }

        try {
            $File = QUI\Projects\Media\Utils::getImageByUrl($fileurl);
            $width = false;
            $height = false;

            if (isset($params['width'])) {
                $width = $params['width'];
            }

            if (isset($params['height'])) {
                $height = $params['height'];
            }

            $url = $File->getSizeCacheUrl($width, $height);

            if (!empty($url)) {
                return $url;
            }

            $url = $File->getUrl(true);

            if (empty($url)) {
                return $File->getUrl();
            }

            return $url;
        } catch (QUI\Exception) {
        }

        return $fileurl;
    },
    ['fileurl', 'params'],
    'Permission::checkAdminUser'
);
