Contribution Guide
======

Guide: How to mix with QUIQQER - Contribution Guide
------

Thank you for taking the time to make QUIQQER better.

In order to keep it clear, we have established guidelines. They apply to QUIQQER and its extensions (packages). 
The guidelines are not carved in stone. We are always open to your changes to this document. 


Report bugs and issues
------

Every software has errors, including QUIQQER. Developers are also only human beings and so errors creep into the 
program code. We collect all errors and improvement requests at https://dev.quiqqer.com/. If you have errors 
or have any suggestions, please post them there. Please describe the error as exactly and in as much detail as possible. 

A screenshot often says more than a thousand words. Information about the browser version can also help. 
There is not too much information about an error.

Often we will go back to you in order to better understand the respective error. 
Therefore, please check your request frequently. As a rule, we will reply within one or two working days at the latest. 
Sometimes we need a few more days. Please be patient then.

Important, so that we can fully understand errors:
Answer our questions. After three months without feedback, we close the error.


Security vulnerabilities
-------

Security vulnerabilities will be resolved immediately. Please send security vulnerabilities directly to support@pcsg.de. 
Describe exactly what it is about. Please explain how the vulnerability can be exploited. 

You can also contact us in our Discord (https://discord.gg/tjWg4ZE).


For Developers
-------

If you want to help develop QUIQQER or even create your own module, have a look at our Discord (https://discord.gg/tjWg4ZE).

Please try to stick to the coding standards as well. We use coding styles and other coding standards so that everyone 
can develop quickly and worry-free. That makes it easier for everyone. 

### Coding Style

QUIQQER follows the PHP coding standard up to PSR-6 and uses JSHINT for JavaScript. Please stick to it as best you can. 

### Develop on QUIQQER

You want to develop directly at the core? That's great. But here we handle the standards extremely strictly, 
because this is the heart of a huge ecosystem. We gladly accept Pull Requests. 

Please submit all Pull Requests at >> https://dev.quiqqer.com/quiqqer/core <<. 
Pull Requests under Github are not accepted.

If you don't know how to start, we will be happy to help you. Just have a look at our Discord.
