<?php

/**
 * This file contains package_quiqqer_coupons_ajax_create
 */

use QUI\ERP\Coupons\CouponCodeException;
use QUI\ERP\Coupons\Handler;
use QUI\Utils\Security\Orthos;

/**
 * Edit a CouponCode
 *
 * @param array $attributes
 * @return bool - success
 */
QUI::$Ajax->registerFunction(
    'package_quiqqer_coupons_ajax_edit',
    function ($id, $attributes) {
        $id = (int)$id;
        $attributes = Orthos::clearArray(json_decode($attributes, true));

        try {
            $discountIds = [];

            if (!empty($attributes['discountIds'])) {
                $discountIds = explode(',', $attributes['discountIds']);
            }

            Handler::editCouponCode($id, $discountIds, $attributes);
        } catch (CouponCodeException $Exception) {
            QUI::getMessagesHandler()->addError(
                QUI::getLocale()->get(
                    'quiqqer/coupons',
                    'message.ajax.edit.error',
                    [
                        'id' => $id,
                        'error' => $Exception->getMessage()
                    ]
                )
            );

            return false;
        } catch (QUI\Permissions\Exception $Exception) {
            throw $Exception;
        } catch (Exception $Exception) {
            QUI\System\Log::writeException($Exception);

            QUI::getMessagesHandler()->addError(
                QUI::getLocale()->get(
                    'quiqqer/coupons',
                    'message.ajax.general_error'
                )
            );

            return false;
        }

        QUI::getMessagesHandler()->addSuccess(
            QUI::getLocale()->get(
                'quiqqer/coupons',
                'message.ajax.edit.success',
                [
                    'id' => $id
                ]
            )
        );

        return true;
    },
    ['id', 'attributes'],
    'Permission::checkAdminUser'
);
