/**
 * Select available CodeGenerators
 *
 * @module package/quiqqer/coupons/bin/backend/controls/settings/CodeGeneratorSelect
 * @author www.pcsg.de (Patrick Müller)
 */
define('package/quiqqer/coupons/bin/backend/controls/settings/CodeGeneratorSelect', [

    'qui/controls/buttons/Select',
    'qui/controls/loader/Loader',

    'Locale',
    'Ajax',

    'css!package/quiqqer/coupons/bin/backend/controls/settings/CodeGeneratorSelect.css'

], function (QUISelect, QUILoader, QUILocale, QUIAjax) {
    "use strict";

    const lg = 'quiqqer/coupons';

    return new Class({
        Extends: QUISelect,
        Type: 'package/quiqqer/coupons/bin/backend/controls/settings/CodeGeneratorSelect',

        Binds: [
            '$onImport'
        ],

        options: {
            showIcons: false
        },

        initialize: function (options) {
            this.parent(options);

            this.$Input = null;
            this.Loader = new QUILoader();

            this.addEvents({
                onImport: this.$onImport
            });
        },

        /**
         * Event: onImport
         */
        $onImport: function () {
            const self = this;

            this.$Input = this.getElm();
            this.$Input.hidden = true;

            const Elm = this.create().inject(this.$Input, 'after');

            Elm.addClass('field-container-field');

            this.Loader.inject(Elm);
            this.Loader.show();

            this.$getCodeGenerators().then(function (codeGenerators) {
                self.Loader.hide();

                for (let i = 0, len = codeGenerators.length; i < len; i++) {
                    self.appendChild(
                        codeGenerators[i],
                        codeGenerators[i]
                    );
                }

                if (self.$Input.value !== '') {
                    self.setValue(self.$Input.value);
                }

                self.addEvent('onChange', function (value) {
                    self.$Input.value = value;
                });
            });
        },

        /**
         * Get list of all CodeGenerators
         *
         * @return {Promise}
         */
        $getCodeGenerators: function () {
            return new Promise(function (resolve, reject) {
                QUIAjax.get('package_quiqqer_coupons_ajax_settings_getCodeGenerators', resolve, {
                    'package': 'quiqqer/coupons',
                    onError: reject
                });
            });
        }
    });
});
