require(['qui/QUI'], function (QUI) {
    "use strict";


    function getCouponPrice(couponId, vat) {
        return new Promise(function (resolve) {
            require(['Ajax'], function (QUIAjax) {
                QUIAjax.get('package_quiqqer_coupons_ajax_backend_getCouponPrice', resolve, {
                    'package': 'quiqqer/coupons',
                    couponId: couponId,
                    vat: vat
                });
            });
        });
    }

    QUI.addEvent('quiqqerErpPriceFactorWindow', function (PriceFactorWindow) {
        const Content = PriceFactorWindow.getContent();
        const Buttons = Content.getElement('.quiqqer-erp-priceFactors-button');
        const ArticleList = PriceFactorWindow.getArticleList();

        require(['Locale'], function (QUILocale) {
            new Element('button', {
                'class': 'qui-button',
                html: '<span class="fa fa-credit-card-alt"></span>',
                title: QUILocale.get('quiqqer/coupons', 'add.coupon.priceFactor'),
                styles: {
                    'float': 'right',
                    marginRight: '10px'
                },
                events: {
                    click: function (e) {
                        e.stop();

                        require([
                            'package/quiqqer/coupons/bin/backend/controls/Window'
                        ], function (CouponWindow) {
                            new CouponWindow({
                                multiple: true,
                                events: {
                                    onSubmit: function (Instance, value) {
                                        if (!value.length) {
                                            return;
                                        }

                                        const currency = ArticleList.getAttribute('currency');
                                        const vat = ArticleList.getVat();
                                        let couponData;

                                        getCouponPrice(value[0].id, vat).then(function (result) {
                                            couponData = result;

                                            return PriceFactorWindow.getPriceFactorData(
                                                couponData.price,
                                                vat,
                                                currency
                                            );
                                        }).then((data) => {
                                            let priceFactor = {
                                                calculation: 2,
                                                calculation_basis: 2,
                                                description: couponData.title,
                                                identifier: "",
                                                index: ArticleList.countPriceFactors(),
                                                nettoSum: data.nettoSum,
                                                nettoSumFormatted: data.nettoSumFormatted,
                                                sum: data.sum,
                                                sumFormatted: data.sumFormatted,
                                                title: couponData.title,
                                                value: data.sum,
                                                valueText: data.valueText,
                                                vat: vat,
                                                visible: 1
                                            };

                                            ArticleList.addPriceFactor(priceFactor);
                                            PriceFactorWindow.refresh();
                                        });
                                    }
                                }
                            }).open();
                        });
                    }
                }
            }).inject(Buttons);
        });
    });
});
