/**
 * CouponCodes Handler (Frontend)
 *
 * @module package/quiqqer/coupons/bin/frontend/classes/CouponCodes
 * @author www.pcsg.de (Patrick Müller)
 *
 * @require Ajax
 */
define('package/quiqqer/coupons/bin/frontend/classes/CouponCodes', [

    'Ajax'

], function (QUIAjax) {
    "use strict";

    const pkg = 'quiqqer/coupons';

    return new Class({

        Type: 'package/quiqqer/coupons/bin/frontend/classes/CouponCodes',

        /**
         * Adds a coupon to the current session basket
         *
         * @param {String} code
         * @param {String} orderHash
         * @return {Promise}
         */
        addCouponCodeToBasket: function (code, orderHash) {
            return new Promise(function (resolve, reject) {
                QUIAjax.post('package_quiqqer_coupons_ajax_frontend_redeem', resolve, {
                    'package': pkg,
                    code: code,
                    orderHash: orderHash,
                    onError: reject,
                    showError: false // disable quiqqer message in frontend
                });
            });
        }
    });
});
