/**
 * CouponCodes Handler
 *
 * @module package/quiqqer/coupons/bin/backend/classes/CouponCodes
 * @author www.pcsg.de (Patrick Müller)
 *
 * @require Ajax
 */
define('package/quiqqer/coupons/bin/backend/classes/CouponCodes', [

    'Ajax'

], function (QUIAjax) {
    "use strict";

    const pkg = 'quiqqer/coupons';

    return new Class({

        Type: 'package/quiqqer/coupons/bin/backend/classes/CouponCodes',

        /**
         * Create new CouponCode
         *
         * @param {Object} Attributes
         * @return {Promise}
         */
        create: function (Attributes) {
            return new Promise(function (resolve, reject) {
                QUIAjax.post('package_quiqqer_coupons_ajax_create', resolve, {
                    'package': pkg,
                    attributes: JSON.encode(Attributes),
                    onError: reject
                });
            });
        },

        /**
         * Edit a CouponCode
         *
         * @param {Number} id
         * @param {Object} Attributes
         * @return {Promise}
         */
        edit: function (id, Attributes) {
            return new Promise(function (resolve, reject) {
                QUIAjax.post('package_quiqqer_coupons_ajax_edit', resolve, {
                    'package': pkg,
                    id: id,
                    attributes: JSON.encode(Attributes),
                    onError: reject
                });
            });
        },

        /**
         * Delete Invite Codes
         *
         * @param {Array} ids
         * @return {Promise}
         */
        delete: function (ids) {
            return new Promise(function (resolve, reject) {
                QUIAjax.post('package_quiqqer_coupons_ajax_delete', resolve, {
                    'package': pkg,
                    ids: JSON.encode(ids),
                    onError: reject
                });
            });
        },

        /**
         * Get list of all CouponCodes
         *
         * @param {Object} SearchParams
         * @return {Promise}
         */
        getList: function (SearchParams) {
            return new Promise(function (resolve, reject) {
                QUIAjax.get('package_quiqqer_coupons_ajax_getList', resolve, {
                    'package': pkg,
                    searchParams: JSON.encode(SearchParams),
                    onError: reject
                });
            });
        },

        /**
         * Send CouponCodes via mail
         *
         * @param {Array} ids
         * @param {Boolean} resend
         * @return {Promise}
         */
        sendMail: function (ids, resend) {
            return new Promise(function (resolve, reject) {
                QUIAjax.post('package_quiqqer_coupons_ajax_sendMail', resolve, {
                    'package': pkg,
                    ids: JSON.encode(ids),
                    resend: resend ? 1 : 0,
                    onError: reject
                });
            });
        }
    });
});
