<?php

namespace QUI\ERP\Coupons;

use QUI;
use QUI\Exception;
use QUI\Utils\System\File;

use function basename;
use function call_user_func;

/**
 * Class CodeGenerator
 *
 * Generated unique, random Invite Codes
 */
class CodeGenerator
{
    /**
     * Generate a new, random Invite Code
     *
     * @return string
     * @throws Exception
     */
    public static function generate(): string
    {
        $generator = '\\QUI\\ERP\\Coupons\\CodeGenerators\\' . self::getCurrentGenerator();

        $Config = QUI::getPackage('quiqqer/coupons')->getConfig();
        $prefix = $Config->get('settings', 'prefix');

        if (empty($prefix)) {
            $prefix = '';
        }

        return call_user_func($generator . '::generate', $prefix);
    }

    /**
     * Get CodeGenerator that is currently set
     *
     * @return string - FQ class name
     * @throws Exception
     */
    protected static function getCurrentGenerator(): string
    {
        $Config = QUI::getPackage('quiqqer/coupons')->getConfig();
        $currentGenerator = $Config->get('settings', 'codeGenerator');

        if (empty($currentGenerator)) {
            return 'SimpleString';
        }

        return $currentGenerator;
    }

    /**
     * Get list of all available CodeGenerators
     *
     * @return array
     * @throws Exception
     */
    public static function getList(): array
    {
        $dir = QUI::getPackage('quiqqer/coupons')->getDir() . 'src/QUI/ERP/Coupons/CodeGenerators';
        $generators = [];

        foreach (File::readDir($dir, true) as $file) {
            $generators[] = basename($file, '.php');
        }

        return $generators;
    }
}
