<?php

namespace QUI\ERP\Coupons\Products;

use QUI;
use QUI\ERP\Products\Product\Types\DigitalProduct;
use QUI\Locale;

/**
 * Class DigitalProduct
 *
 * Represents a non-physical coupon that does not require shipping.
 */
class DigitalCouponProductType extends DigitalProduct
{
    /**
     * Model constructor
     *
     * @param integer $pid - Product-ID
     * @param array $product - Product Data
     *
     * @throws QUI\ERP\Products\Product\Exception
     * @throws QUI\Exception
     */
    public function __construct(int $pid, array $product = [])
    {
        parent::__construct($pid, $product);

        if (!empty($this->fields[Handler::PRODUCT_FIELD_ID_USER_DELIVERY_TYPE_SELECT_ALLOW])) {
            $userDeliveryTypeSelectAllow = $this->getFieldValue(
                Handler::PRODUCT_FIELD_ID_USER_DELIVERY_TYPE_SELECT_ALLOW
            );

            if ($userDeliveryTypeSelectAllow) {
                try {
                    $Field = QUI\ERP\Products\Handler\Fields::getField(
                        Handler::PRODUCT_FIELD_ID_USER_DELIVERY_TYPE_SELECT
                    );

                    $Field->setProduct($this);

                    $this->fields[$Field->getId()] = $Field;
                } catch (QUI\Exception $Exception) {
                    QUI\System\Log::writeException($Exception);
                }
            } else {
                unset($this->fields[Handler::PRODUCT_FIELD_ID_USER_DELIVERY_TYPE_SELECT]);
            }
        }
    }

    /**
     * @param QUI\Locale|null $Locale
     * @return string
     */
    public static function getTypeTitle(null | QUI\Locale $Locale = null): string
    {
        if ($Locale === null) {
            $Locale = QUI::getLocale();
        }

        return $Locale->get('quiqqer/coupons', 'product_type.DigitalCouponProductType.title');
    }

    /**
     * @param Locale|null $Locale
     * @return string
     */
    public static function getTypeDescription(null | QUI\Locale $Locale = null): string
    {
        if ($Locale === null) {
            $Locale = QUI::getLocale();
        }

        return $Locale->get('quiqqer/coupons', 'product_type.DigitalCouponProductType.description');
    }
}
