<?php

/**
 * This file contains package_quiqqer_coupons_ajax_backend_getCouponPrice
 */

/**
 * Return the price factor of this coupon
 *
 * @param int $couponId - CouponCode ID
 * @return array
 */
QUI::getAjax()->registerFunction(
    'package_quiqqer_coupons_ajax_backend_getCouponPrice',
    function ($couponId, $vat) {
        $Coupon = QUI\ERP\Coupons\Handler::getCouponCode($couponId);
        $discounts = $Coupon->getDiscounts();
        $price = 0;

        foreach ($discounts as $Discount) {
            $PriceFactor = $Discount->toPriceFactor();

            if ($PriceFactor->getCalculation() === QUI\ERP\Accounting\Calc::CALCULATION_PERCENTAGE) {
                continue;
            }

            if ($PriceFactor->getCalculation() === QUI\ERP\Accounting\Calc::CALCULATION_COMPLEMENT) {
                continue;
            }

            if ($vat !== false && method_exists($PriceFactor, 'setVat')) {
                $PriceFactor->setVat($vat);
            }

            $PriceFactor->setTitle(
                QUI::getLocale()->get('quiqqer/coupons', 'coupon.discount.title', [
                    'code' => $Coupon->getCode()
                ])
            );

            $price = $price + $PriceFactor->getValue();
        }


        return [
            'title' => $Coupon->getTitle(),
            'price' => $price
        ];
    },
    ['couponId', 'vat'],
    'Permission::checkAdminUser'
);
