<?php

/**
 * This file contains package_quiqqer_coupons_ajax_delete
 */

use QUI\ERP\Coupons\CouponCodeException;
use QUI\ERP\Coupons\Handler;
use QUI\Utils\Security\Orthos;

/**
 * Delete CouponCodes
 *
 * @param array $ids - CouponCode IDs
 * @return bool - success
 */
QUI::getAjax()->registerFunction(
    'package_quiqqer_coupons_ajax_delete',
    function ($ids) {
        $ids = Orthos::clearArray(json_decode($ids, true));

        try {
            foreach ($ids as $id) {
                $CouponCode = Handler::getCouponCode((int)$id);
                $CouponCode->delete();
            }
        } catch (CouponCodeException $Exception) {
            QUI::getMessagesHandler()->addError(
                QUI::getLocale()->get(
                    'quiqqer/coupons',
                    'message.ajax.delete.error',
                    [
                        'error' => $Exception->getMessage()
                    ]
                )
            );

            return false;
        } catch (Exception $Exception) {
            if ($Exception instanceof QUI\Permissions\Exception) {
                throw $Exception;
            }

            QUI\System\Log::writeException($Exception);

            QUI::getMessagesHandler()->addError(
                QUI::getLocale()->get(
                    'quiqqer/coupons',
                    'message.ajax.general_error'
                )
            );

            return false;
        }

        QUI::getMessagesHandler()->addSuccess(
            QUI::getLocale()->get(
                'quiqqer/coupons',
                'message.ajax.delete.success'
            )
        );

        return true;
    },
    ['ids'],
    'Permission::checkAdminUser'
);
