<?php

/**
 * This file contains package_quiqqer_coupons_ajax_frontend_redeem
 */

use QUI\ERP\Coupons\Handler;
use QUI\ERP\Discount\EventHandling as DiscountEvents;

/**
 * Redeem a CouponCode
 *
 * @param int $id - CouponCode ID
 * @return bool - success
 */

/**
 * Redeem a CouponCode
 * @param string $code - coupon code
 * @param string $orderHash - Order hash
 *
 * @throws QUI\Exception
 * @throws QUI\ERP\Coupons\CouponCodeException
 */
QUI::getAjax()->registerFunction(
    'package_quiqqer_coupons_ajax_frontend_redeem',
    function ($code, $orderHash) {
        try {
            $code = Handler::sanitizeCode($code);
            $CouponCode = Handler::getCouponCodeByCode($code);
            $CouponCode->checkRedemption(QUI::getUserBySession());
        } catch (QUI\ERP\Coupons\CouponCodeException $Exception) {
            QUI\System\Log::writeDebugException($Exception);

            throw $Exception;
        } catch (Exception $Exception) {
            QUI\System\Log::writeException($Exception);

            throw new QUI\Exception([
                'quiqqer/coupons',
                'message.ajax.general_error'
            ]);
        }

        $Order = QUI\ERP\Order\Handler::getInstance()->getOrderByHash($orderHash);
        $productCount = $Order->getArticles()->count();

        $calculations = $Order->getArticles()->getCalculations();
        $subSum = $calculations['subSum'];
        $sum = $calculations['sum'];
        $discounts = $CouponCode->getDiscounts();

        foreach ($discounts as $Discount) {
            if (!DiscountEvents::isDiscountUsableWithQuantity($Discount, $productCount)) {
                throw new QUI\Exception([
                    'quiqqer/coupons',
                    'exception.CouponCode.discounts_invalid'
                ]);
            }

            if ($Discount->getAttribute('scope') === QUI\ERP\Discount\Handler::DISCOUNT_SCOPE_GRAND_TOTAL) {
                if (!DiscountEvents::isDiscountUsableWithPurchaseValue($Discount, $sum)) {
                    throw new QUI\Exception([
                        'quiqqer/coupons',
                        'exception.CouponCode.discounts_invalid'
                    ]);
                }

                continue;
            }

            if (!DiscountEvents::isDiscountUsableWithPurchaseValue($Discount, $subSum)) {
                throw new QUI\Exception([
                    'quiqqer/coupons',
                    'exception.CouponCode.discounts_invalid'
                ]);
            }
        }


        $coupons = $Order->getDataEntry('quiqqer-coupons');

        if (empty($coupons)) {
            $coupons = [];
        }

        $coupons[] = $code;

        $coupons = array_unique($coupons);

        $Order->setData('quiqqer-coupons', $coupons);
        $Order->update();

        // add
        if ($Order instanceof QUI\ERP\Order\OrderInProcess) {
            $CouponCode->addToOrder($Order);
        }
    },
    ['code', 'orderHash']
);
