<?php

/**
 * This file contains package_quiqqer_coupons_ajax_frontend_removeCoupons
 */

/**
 * Remove all coupons from an order
 *
 * @param string $orderHash - Order hash
 */
QUI::getAjax()->registerFunction(
    'package_quiqqer_coupons_ajax_frontend_removeCoupons',
    function ($orderHash) {
        $Order = QUI\ERP\Order\Handler::getInstance()->getOrderByHash($orderHash);
        $Articles = $Order->getArticles();

        foreach ($Articles as $index => $Article) {
            $customData = $Article->getCustomData();

            if (!isset($customData['package'])) {
                continue;
            }

            if ($customData['package'] !== 'quiqqer/coupon') {
                continue;
            }

            if (!isset($customData['code'])) {
                continue;
            }

            $Order->removeArticle($index);
        }

        $Order->setData('quiqqer-coupons', []);
        $Order->save();
    },
    ['orderHash']
);
