<?php

/**
 * This file contains package_quiqqer_coupons_ajax_getList
 */

use QUI\ERP\Coupons\Handler;
use QUI\Permissions\Permission;
use QUI\Utils\Grid;
use QUI\Utils\Security\Orthos;

/**
 * Get list of CouponCodes
 *
 * @param array $searchParams
 * @return array
 */
QUI::getAjax()->registerFunction(
    'package_quiqqer_coupons_ajax_getList',
    function ($searchParams) {
        Permission::hasPermission(Handler::PERMISSION_VIEW);

        $searchParams = Orthos::clearArray(json_decode($searchParams, true));
        $couponCodes = [];
        $Users = QUI::getUsers();
        $L = QUI::getLocale();

        try {
            $searchResult = Handler::search($searchParams);

            if (!is_array($searchResult)) {
                $searchResult = [];
            }

            foreach ($searchResult as $CouponCode) {
                $couponCode = $CouponCode->toArray();

                foreach ($couponCode['usages'] as $k => $usage) {
                    // User
                    try {
                        $User = $Users->get($usage['userId']);
                    } catch (QUI\Exception) {
                        continue;
                    }

                    $couponCode['usages'][$k]['userName'] = $User->getUsername();

                    // Date
                    $Date = new DateTime($usage['date']);
                    $couponCode['usages'][$k]['date'] = $L->formatDate($Date->getTimestamp());
                }

                $couponCodes[] = $couponCode;
            }
        } catch (Exception $Exception) {
            QUI\System\Log::writeException($Exception);

            QUI::getMessagesHandler()->addError(
                QUI::getLocale()->get(
                    'quiqqer/coupons',
                    'message.ajax.general_error'
                )
            );

            return false;
        }

        $Grid = new Grid($searchParams);
        $countResult = Handler::search($searchParams, true);
        $count = is_int($countResult) ? $countResult : count($countResult);

        return $Grid->parseResult($couponCodes, $count);
    },
    ['searchParams'],
    'Permission::checkAdminUser'
);
