define('package/quiqqer/coupons/bin/backend/controls/Window', [

    'qui/QUI',
    'qui/controls/windows/Confirm',
    'controls/grid/Grid',
    'Locale',
    'package/quiqqer/coupons/bin/backend/CouponCodes',

], function (QUI, QUIConfirm, Grid, QUILocale, CouponCodes) {
    "use strict";

    const lg = 'quiqqer/coupons';

    return new Class({

        Extends: QUIConfirm,
        Type: 'package/quiqqer/coupons/bin/backend/controls/Window',

        Binds: [
            '$listRefresh',
            '$onOpen',
            '$onResize'
        ],

        initialize: function (options) {
            this.parent(options);

            this.setAttributes({
                icon: 'fa fa-credit-card-alt',
                title: QUILocale.get(lg, 'controls.manager.title'),
                maxHeight: 600,
                maxWidth: 500,
            });

            this.addEvents({
                onOpen: this.$onOpen,
                onResize: this.$onResize
            });
        },

        submit: function () {
            if (!this.$Grid) {
                return;
            }

            this.fireEvent('submit', [
                this,
                this.$Grid.getSelectedData()
            ]);

            if (this.getAttribute('autoclose')) {
                this.close();
            }
        },

        $onOpen: function () {
            this.getContent().set('html', '');
            this.Loader.show();

            const Container = new Element('div').inject(this.getContent());

            this.$Grid = new Grid(Container, {
                columnModel: [
                    {
                        header: QUILocale.get('quiqqer/system', 'id'),
                        dataIndex: 'id',
                        dataType: 'number',
                        width: 50
                    },
                    {
                        header: QUILocale.get(lg, 'controls.manager.tbl.header.code'),
                        dataIndex: 'code',
                        dataType: 'string',
                        width: 150
                    },
                    {
                        header: QUILocale.get(lg, 'controls.manager.tbl.header.title'),
                        dataIndex: 'title',
                        dataType: 'string',
                        width: 200
                    },
                    {
                        header: QUILocale.get(lg, 'controls.manager.tbl.header.status'),
                        dataIndex: 'status',
                        dataType: 'node',
                        width: 200,
                        className: 'clickable'
                    },
                    {
                        header: QUILocale.get(lg, 'controls.manager.tbl.header.validUntilDate'),
                        dataIndex: 'validUntilDateText',
                        dataType: 'string',
                        width: 150
                    },
                    {
                        header: QUILocale.get(lg, 'controls.manager.tbl.header.reusable'),
                        dataIndex: 'maxUsageLabel',
                        dataType: 'string',
                        width: 150
                    },
                    {
                        header: QUILocale.get(lg, 'controls.manager.tbl.header.createDate'),
                        dataIndex: 'createDate',
                        dataType: 'string',
                        width: 150
                    }
                ],
                pagination: true,
                serverSort: true,
                selectable: true,
                multipleSelection: true
            });


            this.$Grid.addEvents({
                onDblClick: () => {
                    this.submit();
                },
                onRefresh: this.$listRefresh
            });

            this.$Grid.refresh();
            this.$onResize();
        },

        $onResize: function () {
            if (!this.$Grid) {
                return;
            }

            this.$Grid.setHeight(
                this.getContent().getSize().y - 40
            );
        },

        /**
         * Refresh bundle list
         *
         * @param {Object} Grid
         */
        $listRefresh: function (Grid) {
            if (!this.$Grid) {
                return;
            }

            let GridParams = {
                sortOn: Grid.getAttribute('sortOn'),
                sortBy: Grid.getAttribute('sortBy'),
                perPage: Grid.getAttribute('perPage'),
                page: Grid.getAttribute('page')
            };

            switch (GridParams.sortOn) {
                case 'status':
                    GridParams.sortOn = 'useDate';
                    break;

                case 'user':
                    GridParams.sortOn = 'userId';
                    break;
            }

            this.Loader.show();

            CouponCodes.getList(GridParams).then((ResultData) => {
                this.Loader.hide();
                this.$setGridData(ResultData);
            });
        },

        /**
         * Set license data to grid
         *
         * @param {Object} GridData
         */
        $setGridData: function (GridData) {
            let textUnlimited = QUILocale.get(lg, 'controls.manager.tbl.validUntil.unlimited');

            for (let i = 0, len = GridData.data.length; i < len; i++) {
                let Row = GridData.data[i];

                let StatusElm = new Element('span', {
                    'class': 'quiqqer-coupons-manager-tbl-status'
                });

                let usageCount = Row.usages.length;

                if (!Row.isValid) {
                    StatusElm.set('html', QUILocale.get(lg, 'controls.manager.tbl.status.invalid', {
                        usageCount: usageCount
                    }));

                    StatusElm.addClass('quiqqer-coupons-manager-tbl-status-invalid');
                } else {
                    StatusElm.set('html', QUILocale.get(lg, 'controls.manager.tbl.status.valid', {
                        usageCount: usageCount
                    }));

                    StatusElm.addClass('quiqqer-coupons-manager-tbl-status-used');
                }

                Row.status = StatusElm;

                if (!Row.validUntilDate) {
                    Row.validUntilDateText = textUnlimited;
                } else {
                    Row.validUntilDateText = Row.validUntilDate;
                }

                if (!Row.title) {
                    Row.title = '-';
                }

                Row.maxUsageLabel = QUILocale.get(lg, 'controls.manager.tbl.maxUsageLabel.' + Row.maxUsages);
            }

            this.$Grid.setData(GridData);
        }
    });
});