<?php

/**
 * This file contains QUI\ERP\Coupons\CodeGenerators\SimpleString
 */

namespace QUI\ERP\Coupons\CodeGenerators;

use Exception;
use QUI\ERP\Coupons\CodeGeneratorInterface;
use QUI\ERP\Coupons\Handler;

use function array_merge;
use function random_int;
use function range;

/**
 * Class SimpleString
 */
class SimpleString implements CodeGeneratorInterface
{
    const CODE_LENGTH = 8;

    /**
     * Generate a random, unique Invite code
     *
     * @param string $prefix (optional)
     * @return string
     * @throws Exception
     */
    public static function generate(string $prefix = ''): string
    {
        $characters = array_merge(
            range('A', 'Z'),
            range(0, 9)
        );

        $count = count($characters) - 1;

        do {
            $code = $prefix;

            for ($i = 0; $i < self::CODE_LENGTH; $i++) {
                $code .= $characters[random_int(0, $count)];
            }
        } while (Handler::existsCode($code));

        return $code;
    }
}
