<?php

namespace QUI\ERP\Coupons\CodeGenerators;

use QUI\ERP\Coupons\CodeGeneratorInterface;
use Ramsey\Uuid\Uuid as UuidCreator;

class Uuid implements CodeGeneratorInterface
{
    /**
     * Generate a random, unique Invite code
     *
     * @param string $prefix (optional)
     * @return string
     */
    public static function generate(string $prefix = ''): string
    {
        return $prefix . UuidCreator::uuid1()->toString();
    }
}
