<?php

/**
 * This file contains QUI\ERP\Discount\PriceFactor
 */

namespace QUI\ERP\Discount;

use QUI;
use QUI\ERP\Products\Interfaces\PriceFactorWithVatInterface;

/**
 * Class PriceFactor
 * This price factor is used by Handler::DISCOUNT_SCOPE_TOTAL
 */
class PriceFactor extends QUI\ERP\Products\Utils\PriceFactor implements PriceFactorWithVatInterface
{
    /**
     * @var string
     */
    protected string $type = Handler::DISCOUNT_PRICEFACTOR_TYPE;

    /**
     * PriceFactor constructor.
     * @param array<string, mixed> $params
     */
    public function __construct(array $params)
    {
        parent::__construct($params);

        if (isset($params['vat'])) {
            $this->vat = $params['vat'];
        }
    }

    /**
     * Return the vat type of the discount price factor
     *
     * @return QUI\ERP\Tax\TaxType
     * @throws QUI\Exception
     */
    public function getVatType(): QUI\ERP\Tax\TaxType
    {
        if (!$this->vat) {
            return $this->getShopTaxTypeOrFallback();
        }

        $standardTax = explode(':', (string)$this->vat);

        if (!isset($standardTax[1])) {
            return $this->getShopTaxTypeOrFallback();
        }

        try {
            $Handler = new QUI\ERP\Tax\Handler();

            return $Handler->getTaxType($standardTax[1]);
        } catch (QUI\Exception) {
        }

        return $this->getShopTaxTypeOrFallback();
    }

    /**
     * @return QUI\ERP\Tax\TaxType
     * @throws QUI\Exception
     */
    protected function getShopTaxTypeOrFallback(): QUI\ERP\Tax\TaxType
    {
        $ShopTaxType = QUI\ERP\Tax\Utils::getShopTaxType();

        if ($ShopTaxType instanceof QUI\ERP\Tax\TaxType) {
            return $ShopTaxType;
        }

        $TaxTypes = (new QUI\ERP\Tax\Handler())->getTaxTypes();

        foreach ($TaxTypes as $TaxType) {
            if ($TaxType instanceof QUI\ERP\Tax\TaxType) {
                return $TaxType;
            }
        }

        throw new QUI\Exception('No tax type available');
    }

    /**
     * @return array<string, mixed>
     */
    public function toArray(): array
    {
        $attributes = parent::toArray();
        $attributes['vat'] = $this->vat;

        return $attributes;
    }
}
