<?php

namespace QUI\ERP\Accounting\Template;

use QUI;
use Smarty;

use function trim;

class EventHandler
{
    /**
     * @param $Output
     * @param QUI\HtmlToPdf\Document $document
     */
    public static function onQuiqqerErpOutputPdfCreate(
        $Output,
        QUI\HtmlToPdf\Document $document
    ): void {
        $class = $Output->getTemplateProvider();
        $class = trim($class, '\\');

        if ($class !== Template::class) {
            return;
        }

        $document->options->foldingMarks = true;

        $document->options->marginTop = 123;
        $document->options->marginBottom = 40;
        $document->options->marginLeft = 0;
        $document->options->marginRight = 0;
    }

    public static function onSmartyInit(Smarty $Smarty): void
    {
        $Smarty->registerClass('QUI\ERP\Defaults', '\QUI\ERP\Defaults');
        $Smarty->registerClass('\QUI\ERP\Defaults', '\QUI\ERP\Defaults');
    }
}
