<?php

namespace QUI\FontAwesome;

class FontAwesome
{
    /**
     * @return int
     */
    public static function getGlobalVersion(): int
    {
        return 6;
    }

    /**
     * @param int|bool $version
     * @return string
     */
    public static function getLinkHtml(int|bool $version = false): string
    {
        if (!$version) {
            $version = self::getGlobalVersion();
        }

        $files = self::getFiles($version);
        $html = '';

        foreach ($files as $file) {
            $html .= '<link href="' . $file . '" rel="stylesheet" type="text/css" />';
        }

        return $html;
    }

    /**
     * @param int|bool $version
     * @return string[]
     */
    public static function getFiles(int|bool $version = false): array
    {
        if (!$version) {
            $version = self::getGlobalVersion();
        }

        if ($version === 6) {
            return [
                URL_OPT_DIR . 'bin/fontawesome/css/all.css',
                URL_OPT_DIR . 'bin/fontawesome/css/v4-shims.css'
            ];
        }

        return [
            URL_OPT_DIR . 'bin/quiqqer-asset/font-awesome/font-awesome/css/font-awesome.css',
            URL_OPT_DIR . 'quiqqer/fontawesome/bin/custom.css'
        ];
    }
}
