<?php

namespace QUI\FontAwesome;

use function array_merge;

/**
 * Class Handler
 */
class Util
{
    public static function getCSSClassList(): array
    {
        return array_merge(
            self::general(),
            self::brands()
        );
    }

    public static function general(): array
    {
        return [
            "fa-add",
            "fa-address-book",
            "fa-address-card",
            "fa-adjust",
            "fa-align-center",
            "fa-align-left",
            "fa-align-right",
            "fa-allergies",
            "fa-american-sign-language-interpreting",
            "fa-anchor-circle-check",
            "fa-anchor-circle-xmark",
            "fa-anchor-lock",
            "fa-angle-double-down",
            "fa-angle-double-left",
            "fa-angle-double-right",
            "fa-angle-double-up",
            "fa-angle-down",
            "fa-angle-up",
            "fa-angles-down",
            "fa-angles-left",
            "fa-angles-right",
            "fa-angles-up",
            "fa-ankh",
            "fa-archive",
            "fa-arrow-alt-circle-down",
            "fa-arrow-alt-circle-left",
            "fa-arrow-circle-down",
            "fa-arrow-down",
            "fa-arrow-down-1-9",
            "fa-arrow-down-9-1",
            "fa-arrow-down-a-z",
            "fa-arrow-down-long",
            "fa-arrow-down-short-wide",
            "fa-arrow-down-up-across-line",
            "fa-arrow-down-up-lock",
            "fa-arrow-left",
            "fa-arrow-left-long",
            "fa-arrow-left-rotate",
            "fa-arrow-right-arrow-left",
            "fa-arrow-right-from-bracket",
            "fa-arrow-right-from-file",
            "fa-arrow-right-long",
            "fa-arrow-right-rotate",
            "fa-arrow-right-to-city",
            "fa-arrow-right-to-file",
            "fa-arrow-rotate-back",
            "fa-arrow-rotate-backward",
            "fa-arrow-rotate-forward",
            "fa-arrow-rotate-left",
            "fa-arrow-rotate-right",
            "fa-arrow-trend-up",
            "fa-arrow-turn-down",
            "fa-arrow-turn-up",
            "fa-arrow-up",
            "fa-arrow-up-1-9",
            "fa-arrow-up-9-1",
            "fa-arrow-up-from-ground-water",
            "fa-arrow-up-from-water-pump",
            "fa-arrow-up-long",
            "fa-arrow-up-right-dots",
            "fa-arrow-up-short-wide",
            "fa-arrow-up-wide-short",
            "fa-arrows",
            "fa-arrows-down-to-line",
            "fa-arrows-left-right-to-line",
            "fa-arrows-spin",
            "fa-arrows-to-circle",
            "fa-arrows-turn-to-dots",
            "fa-arrows-up-down",
            "fa-arrows-up-down-left-right",
            "fa-arrows-up-to-line",
            "fa-arrows-v",
            "fa-asl-interpreting",
            "fa-assistive-listening-systems",
            "fa-asterisk",
            "fa-at",
            "fa-atom",
            "fa-automobile",
            "fa-award",
            "fa-b",
            "fa-baby",
            "fa-baby-carriage",
            "fa-backspace",
            "fa-backward",
            "fa-backward-step",
            "fa-bacteria",
            "fa-bacterium",
            "fa-baht-sign",
            "fa-balance-scale-right",
            "fa-band-aid",
            "fa-bandage",
            "fa-bank",
            "fa-bar-chart",
            "fa-barcode",
            "fa-bars",
            "fa-bars-staggered",
            "fa-baseball",
            "fa-baseball-ball",
            "fa-baseball-bat-ball",
            "fa-bath",
            "fa-bathtub",
            "fa-battery",
            "fa-battery-0",
            "fa-battery-2",
            "fa-battery-3",
            "fa-battery-5",
            "fa-battery-car",
            "fa-battery-empty",
            "fa-battery-full",
            "fa-battery-half",
            "fa-battery-quarter",
            "fa-bed",
            "fa-beer",
            "fa-beer-mug-empty",
            "fa-bell",
            "fa-bell-concierge",
            "fa-bell-slash",
            "fa-bezier-curve",
            "fa-bible",
            "fa-biking",
            "fa-binoculars",
            "fa-biohazard",
            "fa-birthday-cake",
            "fa-blender",
            "fa-blind",
            "fa-blog",
            "fa-bold",
            "fa-bolt",
            "fa-bomb",
            "fa-bone",
            "fa-bong",
            "fa-book-bible",
            "fa-book-dead",
            "fa-book-journal-whills",
            "fa-book-medical",
            "fa-book-open",
            "fa-book-open-reader",
            "fa-book-reader",
            "fa-book-skull",
            "fa-book-tanakh",
            "fa-border-none",
            "fa-border-style",
            "fa-border-top-left",
            "fa-bore-hole",
            "fa-bottle-droplet",
            "fa-bowl-rice",
            "fa-bowling-ball",
            "fa-box-archive",
            "fa-box-open",
            "fa-box-tissue",
            "fa-boxes",
            "fa-boxes-alt",
            "fa-boxes-stacked",
            "fa-braille",
            "fa-brain",
            "fa-brazilian-real-sign",
            "fa-bridge-circle-check",
            "fa-bridge-water",
            "fa-briefcase-clock",
            "fa-briefcase-medical",
            "fa-broadcast-tower",
            "fa-broom",
            "fa-broom-ball",
            "fa-brush",
            "fa-bucket",
            "fa-bug",
            "fa-bug-slash",
            "fa-building",
            "fa-building-circle-arrow-right",
            "fa-building-circle-check",
            "fa-building-circle-xmark",
            "fa-building-columns",
            "fa-building-ngo",
            "fa-building-shield",
            "fa-building-un",
            "fa-burn",
            "fa-business-time",
            "fa-cable-car",
            "fa-cake",
            "fa-cake-candles",
            "fa-calculator",
            "fa-calendar-alt",
            "fa-calendar-check",
            "fa-calendar-day",
            "fa-calendar-days",
            "fa-calendar-minus",
            "fa-calendar-plus",
            "fa-calendar-times",
            "fa-calendar-week",
            "fa-calendar-xmark",
            "fa-camera",
            "fa-camera-alt",
            "fa-camera-retro",
            "fa-cannabis",
            "fa-car",
            "fa-car-alt",
            "fa-car-battery",
            "fa-car-burst",
            "fa-car-crash",
            "fa-car-on",
            "fa-car-rear",
            "fa-car-tunnel",
            "fa-caravan",
            "fa-caret-down",
            "fa-caret-left",
            "fa-caret-right",
            "fa-caret-square-down",
            "fa-caret-square-right",
            "fa-caret-square-up",
            "fa-caret-up",
            "fa-carriage-baby",
            "fa-carrot",
            "fa-cart-arrow-down",
            "fa-cart-flatbed-suitcase",
            "fa-cart-plus",
            "fa-cart-shopping",
            "fa-bag-shopping",
            "fa-cent-sign",
            "fa-certificate",
            "fa-chain",
            "fa-chair",
            "fa-chalkboard-teacher",
            "fa-chalkboard-user",
            "fa-champagne-glasses",
            "fa-chart-bar",
            "fa-chart-gantt",
            "fa-check-circle",
            "fa-check-double",
            "fa-check-square",
            "fa-check-to-slot",
            "fa-cheese",
            "fa-chess",
            "fa-chess-board",
            "fa-chess-king",
            "fa-chess-pawn",
            "fa-chess-queen",
            "fa-chess-rook",
            "fa-chevron-circle-down",
            "fa-chevron-circle-left",
            "fa-chevron-circle-right",
            "fa-chevron-circle-up",
            "fa-chevron-down",
            "fa-chevron-left",
            "fa-chevron-right",
            "fa-child",
            "fa-child-combatant",
            "fa-child-dress",
            "fa-child-reaching",
            "fa-child-rifle",
            "fa-circle-arrow-down",
            "fa-circle-check",
            "fa-circle-chevron-down",
            "fa-circle-chevron-left",
            "fa-circle-chevron-right",
            "fa-circle-chevron-up",
            "fa-circle-dollar-to-slot",
            "fa-circle-dot",
            "fa-circle-down",
            "fa-circle-exclamation",
            "fa-circle-h",
            "fa-circle-half-stroke",
            "fa-circle-info",
            "fa-circle-left",
            "fa-circle-minus",
            "fa-circle-nodes",
            "fa-circle-notch",
            "fa-circle-play",
            "fa-circle-radiation",
            "fa-circle-stop",
            "fa-circle-user",
            "fa-circle-xmark",
            "fa-clapperboard",
            "fa-clinic-medical",
            "fa-clipboard",
            "fa-clipboard-list",
            "fa-clipboard-user",
            "fa-clock",
            "fa-clock-four",
            "fa-clock-rotate-left",
            "fa-close",
            "fa-closed-captioning",
            "fa-cloud",
            "fa-cloud-meatball",
            "fa-cloud-rain",
            "fa-cloud-showers-heavy",
            "fa-cloud-showers-water",
            "fa-cloud-sun",
            "fa-cloud-sun-rain",
            "fa-clover",
            "fa-cny",
            "fa-code-commit",
            "fa-code-compare",
            "fa-code-merge",
            "fa-code-pull-request",
            "fa-coffee",
            "fa-cog",
            "fa-cogs",
            "fa-coins",
            "fa-columns",
            "fa-comment",
            "fa-solid fa-comments",
            "fa-comment-alt",
            "fa-comment-dollar",
            "fa-comment-dots",
            "fa-comment-slash",
            "fa-commenting",
            "fa-comments",
            "fa-comments-o",
            "fa-compact-disc",
            "fa-compass",
            "fa-compass-drafting",
            "fa-compress",
            "fa-compress-alt",
            "fa-compress-arrows-alt",
            "fa-computer",
            "fa-concierge-bell",
            "fa-contact-book",
            "fa-contact-card",
            "fa-cookie",
            "fa-copy",
            "fa-copyright",
            "fa-cow",
            "fa-credit-card",
            "fa-credit-card-alt",
            "fa-crop",
            "fa-crop-alt",
            "fa-crop-simple",
            "fa-crosshairs",
            "fa-crow",
            "fa-cubes",
            "fa-cut",
            "fa-cutlery",
            "fa-d",
            "fa-database",
            "fa-dedent",
            "fa-delete-left",
            "fa-dharmachakra",
            "fa-diagnoses",
            "fa-diagram-next",
            "fa-diagram-predecessor",
            "fa-diagram-project",
            "fa-diamond",
            "fa-dice",
            "fa-dice-d20",
            "fa-dice-d6",
            "fa-dice-four",
            "fa-dice-one",
            "fa-dice-six",
            "fa-dice-three",
            "fa-dice-two",
            "fa-digging",
            "fa-digital-tachograph",
            "fa-disease",
            "fa-display",
            "fa-divide",
            "fa-dizzy",
            "fa-dna",
            "fa-dog",
            "fa-dollar",
            "fa-dollar-sign",
            "fa-dolly",
            "fa-dolly-box",
            "fa-donate",
            "fa-door-closed",
            "fa-door-open",
            "fa-dot-circle",
            "fa-dove",
            "fa-down-left-and-up-right-to-center",
            "fa-down-long",
            "fa-download",
            "fa-drafting-compass",
            "fa-drivers-license",
            "fa-droplet",
            "fa-droplet-slash",
            "fa-drum",
            "fa-drum-steelpan",
            "fa-drumstick-bite",
            "fa-dumbbell",
            "fa-dungeon",
            "fa-ear-listen",
            "fa-earth",
            "fa-earth-africa",
            "fa-earth-america",
            "fa-earth-americas",
            "fa-earth-asia",
            "fa-earth-oceania",
            "fa-ellipsis",
            "fa-ellipsis-h",
            "fa-ellipsis-v",
            "fa-ellipsis-vertical",
            "fa-envelope",
            "fa-envelope-o",
            "fa-envelope-open-text",
            "fa-envelope-square",
            "fa-envelopes-bulk",
            "fa-equals",
            "fa-eraser",
            "fa-ethernet",
            "fa-eur",
            "fa-euro",
            "fa-euro-sign",
            "fa-exchange",
            "fa-exchange-alt",
            "fa-exclamation",
            "fa-exclamation-circle",
            "fa-exclamation-triangle",
            "fa-expand",
            "fa-explosion",
            "fa-external-link-alt",
            "fa-external-link-square",
            "fa-external-link-square-alt",
            "fa-eye-dropper",
            "fa-eye-dropper-empty",
            "fa-eye-low-vision",
            "fa-eyedropper",
            "fa-face-dizzy",
            "fa-face-flushed",
            "fa-face-grimace",
            "fa-face-grin",
            "fa-face-grin-beam-sweat",
            "fa-face-grin-hearts",
            "fa-face-grin-squint",
            "fa-face-grin-squint-tears",
            "fa-face-grin-stars",
            "fa-face-grin-tears",
            "fa-face-grin-tongue-squint",
            "fa-face-kiss-beam",
            "fa-face-laugh-beam",
            "fa-face-laugh-wink",
            "fa-face-meh",
            "fa-face-sad-tear",
            "fa-face-smile",
            "fa-face-smile-beam",
            "fa-faucet",
            "fa-fax",
            "fa-feather",
            "fa-female",
            "fa-fighter-jet",
            "fa-file",
            "fa-file-alt",
            "fa-file-arrow-down",
            "fa-file-arrow-up",
            "fa-file-circle-check",
            "fa-file-circle-exclamation",
            "fa-file-circle-question",
            "fa-file-circle-xmark",
            "fa-file-clipboard",
            "fa-file-csv",
            "fa-file-download",
            "fa-file-edit",
            "fa-file-export",
            "fa-file-import",
            "fa-file-invoice",
            "fa-file-lines",
            "fa-file-medical",
            "fa-file-pdf",
            "fa-file-pen",
            "fa-file-text",
            "fa-file-upload",
            "fa-file-video",
            "fa-fill",
            "fa-fill-drip",
            "fa-film",
            "fa-filter-circle-dollar",
            "fa-fingerprint",
            "fa-fire-burner",
            "fa-fire-flame-simple",
            "fa-first-aid",
            "fa-fish",
            "fa-flag",
            "fa-flag-checkered",
            "fa-flag-usa",
            "fa-flask",
            "fa-florin-sign",
            "fa-flushed",
            "fa-folder-closed",
            "fa-folder-minus",
            "fa-folder-tree",
            "fa-font",
            "fa-font-icons",
            "fa-football",
            "fa-football-ball",
            "fa-forward",
            "fa-forward-step",
            "fa-franc-sign",
            "fa-frog",
            "fa-funnel-dollar",
            "fa-gamepad",
            "fa-gauge-high",
            "fa-gauge-simple",
            "fa-gauge-simple-med",
            "fa-gavel",
            "fa-gbp",
            "fa-gear",
            "fa-gears",
            "fa-gem",
            "fa-genderless",
            "fa-ghost",
            "fa-gift",
            "fa-gifts",
            "fa-glass-cheers",
            "fa-glass-martini-alt",
            "fa-glass-water",
            "fa-glass-water-droplet",
            "fa-glasses",
            "fa-globe-africa",
            "fa-globe-americas",
            "fa-globe-asia",
            "fa-globe-oceania",
            "fa-golf-ball",
            "fa-golf-ball-tee",
            "fa-gopuram",
            "fa-graduation-cap",
            "fa-greater-than",
            "fa-grimace",
            "fa-grin",
            "fa-grin-beam-sweat",
            "fa-grin-hearts",
            "fa-grin-squin",
            "fa-grin-squint-tears",
            "fa-grin-stars",
            "fa-grin-tears",
            "fa-grin-tongue-squint",
            "fa-grip",
            "fa-grip-horizontal",
            "fa-grip-lines",
            "fa-grip-vertical",
            "fa-guitar",
            "fa-gun",
            "fa-h-square",
            "fa-hammer",
            "fa-hamsa",
            "fa-hand-back-fist",
            "fa-hand-dots",
            "fa-hand-holding-dollar",
            "fa-hand-holding-droplet",
            "fa-hand-holding-hand",
            "fa-hand-holding-medical",
            "fa-hand-holding-usd",
            "fa-hand-holding-water",
            "fa-hand-lizard",
            "fa-hand-middle-finger",
            "fa-hand-peace",
            "fa-hand-point-left",
            "fa-hand-point-right",
            "fa-hand-pointer",
            "fa-hand-rock",
            "fa-hand-scissors",
            "fa-hand-sparkles",
            "fa-handcuffs",
            "fa-hands",
            "fa-hands-american-sign-language-interpreting",
            "fa-hands-asl-interpreting",
            "fa-hands-bubbles",
            "fa-hands-clapping",
            "fa-hands-helping",
            "fa-hands-holding",
            "fa-hands-holding-child",
            "fa-hands-holding-circle",
            "fa-hands-praying",
            "fa-hands-wash",
            "fa-handshake",
            "fa-handshake-alt",
            "fa-handshake-angle",
            "fa-handshake-simple",
            "fa-hanukiah",
            "fa-hard-drive",
            "fa-hat-cowboy-side",
            "fa-hat-wizard",
            "fa-hdd",
            "fa-head-side-cough",
            "fa-head-side-mask",
            "fa-head-side-virus",
            "fa-header",
            "fa-heading",
            "fa-headphones",
            "fa-headphones-alt",
            "fa-headphones-simple",
            "fa-heart-broken",
            "fa-heart-circle-bolt",
            "fa-heart-circle-exclamation",
            "fa-heart-crack",
            "fa-heart-music-camera-bolt",
            "fa-helicopter",
            "fa-helicopter-symbol",
            "fa-hiking",
            "fa-hill-avalanche",
            "fa-hill-rockslide",
            "fa-history",
            "fa-hockey-puck",
            "fa-holly-berry",
            "fa-home",
            "fa-home-alt",
            "fa-home-lg-alt",
            "fa-horse-head",
            "fa-hospital",
            "fa-hospital-alt",
            "fa-hospital-symbol",
            "fa-hospital-user",
            "fa-hospital-wide",
            "fa-hotdog",
            "fa-hotel",
            "fa-hourglass",
            "fa-hourglass-3",
            "fa-hourglass-empty",
            "fa-hourglass-end",
            "fa-house",
            "fa-house-chimney-medical",
            "fa-house-chimney-window",
            "fa-house-circle-exclamation",
            "fa-house-fire",
            "fa-house-medical",
            "fa-house-medical-circle-check",
            "fa-house-medical-circle-exclamation",
            "fa-house-tsunami",
            "fa-hurricane",
            "fa-ice-cream",
            "fa-icicles",
            "fa-icons",
            "fa-id-badge",
            "fa-id-card",
            "fa-id-card-alt",
            "fa-id-card-clip",
            "fa-ils",
            "fa-image",
            "fa-images",
            "fa-inbox",
            "fa-indent",
            "fa-indian-rupee",
            "fa-indian-rupee-sign",
            "fa-industry",
            "fa-info",
            "fa-info-circle",
            "fa-inr",
            "fa-institution",
            "fa-j",
            "fa-jar",
            "fa-jar-wheat",
            "fa-jedi",
            "fa-jet-fighter",
            "fa-jet-fighter-up",
            "fa-journal-whills",
            "fa-jpy",
            "fa-jug-detergent",
            "fa-k",
            "fa-keyboard",
            "fa-khanda",
            "fa-kip-sign",
            "fa-kiss-beam",
            "fa-kit-medical",
            "fa-kiwi-bird",
            "fa-ladder-water",
            "fa-landmark",
            "fa-landmark-alt",
            "fa-landmark-dome",
            "fa-landmark-flag",
            "fa-laptop",
            "fa-laptop-code",
            "fa-laptop-file",
            "fa-laptop-medical",
            "fa-lari-sign",
            "fa-laugh-beam",
            "fa-laugh-wink",
            "fa-left-long",
            "fa-legal",
            "fa-lemon",
            "fa-less-than",
            "fa-less-than-equal",
            "fa-level-down",
            "fa-level-down-alt",
            "fa-level-up",
            "fa-level-up-alt",
            "fa-life-ring",
            "fa-lightbulb",
            "fa-lines-leaning",
            "fa-link",
            "fa-lira-sign",
            "fa-list",
            "fa-list-alt",
            "fa-list-check",
            "fa-list-dots",
            "fa-list-squares",
            "fa-list-ul",
            "fa-litecoin-sign",
            "fa-location",
            "fa-location-crosshairs",
            "fa-location-dot",
            "fa-location-pin-lock",
            "fa-long-arrow-alt-down",
            "fa-long-arrow-alt-left",
            "fa-long-arrow-alt-right",
            "fa-long-arrow-alt-up",
            "fa-long-arrow-down",
            "fa-long-arrow-left",
            "fa-long-arrow-right",
            "fa-long-arrow-up",
            "fa-low-vision",
            "fa-luggage-cart",
            "fa-lungs",
            "fa-lungs-virus",
            "fa-magic",
            "fa-magnet",
            "fa-magnifying-glass",
            "fa-magnifying-glass-arrow-right",
            "fa-magnifying-glass-dollar",
            "fa-magnifying-glass-location",
            "fa-magnifying-glass-minus",
            "fa-magnifying-glass-plus",
            "fa-mail-bulk",
            "fa-mail-forward",
            "fa-mail-reply",
            "fa-mail-reply-all",
            "fa-male",
            "fa-manat-sign",
            "fa-map",
            "fa-map-location-dot",
            "fa-map-marked-alt",
            "fa-map-marker-alt",
            "fa-map-pin",
            "fa-marker",
            "fa-mars",
            "fa-mars-and-venus-burst",
            "fa-mars-double",
            "fa-mars-stroke-h",
            "fa-mars-stroke-right",
            "fa-mars-stroke-up",
            "fa-mars-stroke-v",
            "fa-martini-glass",
            "fa-mask",
            "fa-mask-face",
            "fa-masks-theater",
            "fa-medal",
            "fa-medkit",
            "fa-meh",
            "fa-memory",
            "fa-menorah",
            "fa-mercury",
            "fa-message",
            "fa-meteor",
            "fa-microphone",
            "fa-microphone-alt-slash",
            "fa-microphone-lines-slash",
            "fa-microphone-slash",
            "fa-mill-sign",
            "fa-minimize",
            "fa-minus",
            "fa-minus-circle",
            "fa-minus-square",
            "fa-mobile",
            "fa-mobile-android",
            "fa-mobile-android-alt",
            "fa-mobile-phone",
            "fa-mobile-screen",
            "fa-money-bill-1",
            "fa-money-bill-1-wave",
            "fa-money-bill-alt",
            "fa-money-bill-wave-alt",
            "fa-money-bill-wheat",
            "fa-monument",
            "fa-moon",
            "fa-mortar-board",
            "fa-mosque",
            "fa-mosquito",
            "fa-mosquito-net",
            "fa-motorcycle",
            "fa-mound",
            "fa-mountain",
            "fa-mountain-city",
            "fa-mountain-sun",
            "fa-mug-hot",
            "fa-mug-saucer",
            "fa-multiply",
            "fa-museum",
            "fa-music",
            "fa-n",
            "fa-naira-sign",
            "fa-navicon",
            "fa-network-wired",
            "fa-neuter",
            "fa-not-equal",
            "fa-notdef",
            "fa-note-sticky",
            "fa-o",
            "fa-oil-well",
            "fa-otter",
            "fa-outdent",
            "fa-pager",
            "fa-paint-roller",
            "fa-pallet",
            "fa-paper-plane",
            "fa-paperclip",
            "fa-parachute-box",
            "fa-paragraph",
            "fa-pastafarianism",
            "fa-paste",
            "fa-pause",
            "fa-paw",
            "fa-peace",
            "fa-pen-fancy",
            "fa-pen-nib",
            "fa-pen-ruler",
            "fa-pen-square",
            "fa-pencil",
            "fa-pencil-alt",
            "fa-pencil-ruler",
            "fa-pencil-square",
            "fa-people-arrows",
            "fa-people-arrows-left-right",
            "fa-people-group",
            "fa-people-line",
            "fa-people-pulling",
            "fa-people-robbery",
            "fa-people-roof",
            "fa-percent",
            "fa-percentage",
            "fa-person",
            "fa-person-arrow-up-from-line",
            "fa-person-biking",
            "fa-person-booth",
            "fa-person-burst",
            "fa-person-cane",
            "fa-person-chalkboard",
            "fa-person-circle-check",
            "fa-person-circle-exclamation",
            "fa-person-circle-xmark",
            "fa-person-digging",
            "fa-person-dots-from-line",
            "fa-person-dress",
            "fa-person-drowning",
            "fa-person-falling-burst",
            "fa-person-harassing",
            "fa-person-hiking",
            "fa-person-military-pointing",
            "fa-person-military-rifle",
            "fa-person-praying",
            "fa-person-pregnant",
            "fa-person-rifle",
            "fa-person-shelter",
            "fa-person-skating",
            "fa-person-skiing-nordic",
            "fa-person-snowboarding",
            "fa-person-swimming",
            "fa-person-through-window",
            "fa-person-walking-arrow-right",
            "fa-person-walking-dashed-line-arrow-right",
            "fa-person-walking-with-cane",
            "fa-peseta-sign",
            "fa-peso-sign",
            "fa-phone",
            "fa-phone-slash",
            "fa-phone-square",
            "fa-phone-square-alt",
            "fa-phone-volume",
            "fa-photo-film",
            "fa-photo-video",
            "fa-piggy-bank",
            "fa-ping-pong-paddle-ball",
            "fa-place-of-worship",
            "fa-plane",
            "fa-plane-arrival",
            "fa-plane-circle-xmark",
            "fa-plane-lock",
            "fa-plane-up",
            "fa-plant-wilt",
            "fa-plate-wheat",
            "fa-play",
            "fa-play-circle",
            "fa-plug-circle-check",
            "fa-plug-circle-minus",
            "fa-plug-circle-plus",
            "fa-plug-circle-xmark",
            "fa-plus",
            "fa-plus-minus",
            "fa-plus-square",
            "fa-podcast",
            "fa-poll",
            "fa-poo",
            "fa-pound-sign",
            "fa-power-off",
            "fa-pray",
            "fa-praying-hands",
            "fa-prescription-bottle",
            "fa-prescription-bottle-alt",
            "fa-prescription-bottle-medical",
            "fa-print",
            "fa-project-diagram",
            "fa-pump-medical",
            "fa-pump-soap",
            "fa-qrcode",
            "fa-quidditch",
            "fa-quidditch-broom-ball",
            "fa-quote-left",
            "fa-quote-left-alt",
            "fa-quote-right",
            "fa-quote-right-alt",
            "fa-radiation-alt",
            "fa-radio",
            "fa-rainbow",
            "fa-ranking-star",
            "fa-receipt",
            "fa-record-vinyl",
            "fa-rectangle-list",
            "fa-rectangle-times",
            "fa-rectangle-xmark",
            "fa-redo",
            "fa-redo-alt",
            "fa-registered",
            "fa-remove",
            "fa-reorder",
            "fa-reply",
            "fa-reply-all",
            "fa-republican",
            "fa-restroom",
            "fa-retweet",
            "fa-ribbon",
            "fa-right-from-bracket",
            "fa-right-left",
            "fa-right-long",
            "fa-ring",
            "fa-rmb",
            "fa-road-circle-exclamation",
            "fa-road-circle-xmark",
            "fa-road-spikes",
            "fa-robot",
            "fa-rocket",
            "fa-rotate",
            "fa-rotate-back",
            "fa-rotate-backward",
            "fa-rotate-forward",
            "fa-rotate-left",
            "fa-rotate-right",
            "fa-rouble",
            "fa-rub",
            "fa-ruble",
            "fa-ruble-sign",
            "fa-ruler",
            "fa-ruler-combined",
            "fa-ruler-horizontal",
            "fa-ruler-vertical",
            "fa-rupiah-sign",
            "fa-s",
            "fa-sad-tear",
            "fa-sailboat",
            "fa-satellite",
            "fa-scale-unbalanced-flip",
            "fa-school-circle-exclamation",
            "fa-school-circle-xmark",
            "fa-school-flag",
            "fa-school-lock",
            "fa-scissors",
            "fa-screwdriver",
            "fa-scroll",
            "fa-scroll-torah",
            "fa-search",
            "fa-search-dollar",
            "fa-search-location",
            "fa-search-minus",
            "fa-search-plus",
            "fa-section",
            "fa-share",
            "fa-share-alt-square",
            "fa-share-from-square",
            "fa-share-square",
            "fa-sheet-plastic",
            "fa-shekel",
            "fa-shekel-sign",
            "fa-sheqel",
            "fa-sheqel-sign",
            "fa-shield",
            "fa-shield-blank",
            "fa-shield-cat",
            "fa-shield-heart",
            "fa-shield-virus",
            "fa-ship",
            "fa-shipping-fast",
            "fa-shirt",
            "fa-shopping-cart",
            "fa-shrimp",
            "fa-sign",
            "fa-sign-hanging",
            "fa-sign-language",
            "fa-sign-out",
            "fa-sign-out-alt",
            "fa-signature",
            "fa-signing",
            "fa-sim-card",
            "fa-sitemap",
            "fa-skating",
            "fa-skiing-nordic",
            "fa-skull",
            "fa-skull-crossbones",
            "fa-sleigh",
            "fa-sliders",
            "fa-sliders-h",
            "fa-smile",
            "fa-smile-beam",
            "fa-smoking",
            "fa-snowboarding",
            "fa-snowplow",
            "fa-soap",
            "fa-socks",
            "fa-sort-alpha-asc",
            "fa-sort-alpha-down",
            "fa-sort-amount-desc",
            "fa-sort-amount-down-alt",
            "fa-sort-amount-up",
            "fa-sort-amount-up-alt",
            "fa-sort-asc",
            "fa-sort-desc",
            "fa-sort-down",
            "fa-sort-numeric-asc",
            "fa-sort-numeric-desc",
            "fa-sort-numeric-down",
            "fa-sort-numeric-down-alt",
            "fa-sort-numeric-up",
            "fa-sort-numeric-up-alt",
            "fa-sort-up",
            "fa-spa",
            "fa-spaghetti-monster-flying",
            "fa-spinner",
            "fa-splotch",
            "fa-spoon",
            "fa-spray-can",
            "fa-square-arrow-up-right",
            "fa-square-caret-down",
            "fa-square-caret-right",
            "fa-square-caret-up",
            "fa-square-check",
            "fa-square-envelope",
            "fa-square-full",
            "fa-square-h",
            "fa-square-minus",
            "fa-square-nfi",
            "fa-square-pen",
            "fa-square-person-confined",
            "fa-square-phone",
            "fa-square-phone-flip",
            "fa-square-plus",
            "fa-square-poll-vertical",
            "fa-square-root-alt",
            "fa-square-root-variable",
            "fa-square-share-nodes",
            "fa-square-up-right",
            "fa-square-virus",
            "fa-stapler",
            "fa-star-and-crescent",
            "fa-star-half",
            "fa-star-of-david",
            "fa-star-of-life",
            "fa-step-backward",
            "fa-step-forward",
            "fa-sterling-sign",
            "fa-stethoscope",
            "fa-sticky-note",
            "fa-stop",
            "fa-stop-circle",
            "fa-stopwatch-20",
            "fa-store",
            "fa-stream",
            "fa-street-view",
            "fa-strikethrough",
            "fa-stroopwafel",
            "fa-subtract",
            "fa-subway",
            "fa-suitcase",
            "fa-suitcase-medical",
            "fa-suitcase-rolling",
            "fa-sun",
            "fa-sun-plant-wilt",
            "fa-superscript",
            "fa-swatchbook",
            "fa-swimmer",
            "fa-swimming-pool",
            "fa-sync-alt",
            "fa-syringe",
            "fa-t-shirt",
            "fa-table",
            "fa-table-cells",
            "fa-table-cells-large",
            "fa-table-columns",
            "fa-table-tennis",
            "fa-table-tennis-paddle-ball",
            "fa-tablet",
            "fa-tablet-alt",
            "fa-tablet-android",
            "fa-tablet-screen-button",
            "fa-tablets",
            "fa-tachograph-digital",
            "fa-tachometer-alt",
            "fa-tachometer-alt-fast",
            "fa-tachometer-average",
            "fa-tag",
            "fa-tanakh",
            "fa-tarp-droplet",
            "fa-tasks",
            "fa-teeth",
            "fa-teletype",
            "fa-television",
            "fa-temperature-0",
            "fa-temperature-3",
            "fa-temperature-4",
            "fa-temperature-arrow-up",
            "fa-temperature-empty",
            "fa-temperature-full",
            "fa-temperature-low",
            "fa-temperature-three-quarters",
            "fa-temperature-up",
            "fa-tenge",
            "fa-tenge-sign",
            "fa-tent",
            "fa-tent-arrow-down-to-line",
            "fa-tent-arrow-left-right",
            "fa-tent-arrow-turn-left",
            "fa-tent-arrows-down",
            "fa-tents",
            "fa-text-height",
            "fa-text-width",
            "fa-th",
            "fa-th-large",
            "fa-theater-masks",
            "fa-thermometer",
            "fa-thermometer-0",
            "fa-thermometer-3",
            "fa-thermometer-4",
            "fa-thermometer-empty",
            "fa-thermometer-full",
            "fa-thermometer-three-quarters",
            "fa-thumb-tack",
            "fa-thumbs-down",
            "fa-thumbs-up",
            "fa-thumbtack",
            "fa-ticket",
            "fa-ticket-alt",
            "fa-ticket-simple",
            "fa-timeline",
            "fa-times",
            "fa-times-circle",
            "fa-times-rectangle",
            "fa-tint",
            "fa-tint-slash",
            "fa-toggle-off",
            "fa-toilet",
            "fa-toilet-portable",
            "fa-toilets-portable",
            "fa-toolbox",
            "fa-torah",
            "fa-torii-gate",
            "fa-tower-broadcast",
            "fa-tower-cell",
            "fa-tractor",
            "fa-traffic-light",
            "fa-train",
            "fa-train-subway",
            "fa-train-tram",
            "fa-tram",
            "fa-transgender",
            "fa-transgender-alt",
            "fa-trash",
            "fa-trash-alt",
            "fa-trash-arrow-up",
            "fa-trash-can",
            "fa-trash-can-arrow-up",
            "fa-trash-restore",
            "fa-trash-restore-alt",
            "fa-tree-city",
            "fa-triangle-exclamation",
            "fa-trophy",
            "fa-trowel",
            "fa-trowel-bricks",
            "fa-truck",
            "fa-truck-droplet",
            "fa-truck-fast",
            "fa-truck-field-un",
            "fa-truck-loading",
            "fa-truck-monster",
            "fa-truck-moving",
            "fa-truck-pickup",
            "fa-truck-plane",
            "fa-truck-ramp-box",
            "fa-try",
            "fa-tshirt",
            "fa-tty",
            "fa-turkish-lira",
            "fa-turkish-lira-sign",
            "fa-turn-down",
            "fa-turn-up",
            "fa-tv",
            "fa-tv-alt",
            "fa-u",
            "fa-umbrella",
            "fa-underline",
            "fa-undo",
            "fa-undo-alt",
            "fa-universal-access",
            "fa-university",
            "fa-unlock-alt",
            "fa-unlock-keyhole",
            "fa-up-long",
            "fa-up-right-from-square",
            "fa-upload",
            "fa-usd",
            "fa-user-alt",
            "fa-user-check",
            "fa-user-circle",
            "fa-user-clock",
            "fa-user-cog",
            "fa-user-doctor",
            "fa-user-edit",
            "fa-user-gear",
            "fa-user-graduate",
            "fa-user-injured",
            "fa-user-large",
            "fa-user-lock",
            "fa-user-md",
            "fa-user-minus",
            "fa-user-ninja",
            "fa-user-nurse",
            "fa-user-pen",
            "fa-user-secret",
            "fa-user-shield",
            "fa-user-tie",
            "fa-user-times",
            "fa-user-xmark",
            "fa-users-between-lines",
            "fa-users-cog",
            "fa-users-gear",
            "fa-users-line",
            "fa-users-rectangle",
            "fa-users-slash",
            "fa-users-viewfinder",
            "fa-utensil-spoon",
            "fa-utensils",
            "fa-vault",
            "fa-vcard",
            "fa-venus-double",
            "fa-vest-patches",
            "fa-vial-virus",
            "fa-vials",
            "fa-video",
            "fa-video-camera",
            "fa-video-slash",
            "fa-virus-slash",
            "fa-viruses",
            "fa-volcano",
            "fa-volleyball",
            "fa-volleyball-ball",
            "fa-volume-control-phone",
            "fa-volume-down",
            "fa-volume-low",
            "fa-volume-mute",
            "fa-volume-off",
            "fa-volume-times",
            "fa-volume-xmark",
            "fa-vote-yea",
            "fa-vr-cardboard",
            "fa-w",
            "fa-walkie-talkie",
            "fa-wand-magic",
            "fa-wand-sparkles",
            "fa-warehouse",
            "fa-warning",
            "fa-water",
            "fa-water-ladder",
            "fa-wave-square",
            "fa-wheat-alt",
            "fa-wheat-awn",
            "fa-wheelchair-alt",
            "fa-wheelchair-move",
            "fa-wifi",
            "fa-wifi-3",
            "fa-wifi-strong",
            "fa-wind",
            "fa-window-close",
            "fa-window-minimize",
            "fa-window-restore",
            "fa-wine-bottle",
            "fa-wine-glass-alt",
            "fa-wine-glass-empty",
            "fa-x",
            "fa-xmark",
            "fa-xmark-circle",
            "fa-y",
            "fa-yen",
            "fa-yen-sign",
            "fa-yin-yang",
            "fa-zap"
        ];
    }

    public static function brands(): array
    {
        return [

            "fa-brands fa-42-group",
            "fa-brands fa-500px",
            "fa-brands fa-accessible-icon",
            "fa-brands fa-accusoft",
            "fa-brands fa-adn",
            "fa-brands fa-adversal",
            "fa-brands fa-affiliatetheme",
            "fa-brands fa-airbnb",
            "fa-brands fa-algolia",
            "fa-brands fa-alipay",
            "fa-brands fa-amazon",
            "fa-brands fa-amazon-pay",
            "fa-brands fa-amilia",
            "fa-brands fa-android",
            "fa-brands fa-angellist",
            "fa-brands fa-angrycreative",
            "fa-brands fa-angular",
            "fa-brands fa-app-store",
            "fa-brands fa-app-store-ios",
            "fa-brands fa-apper",
            "fa-brands fa-apple",
            "fa-brands fa-apple-pay",
            "fa-brands fa-artstation",
            "fa-brands fa-asymmetrik",
            "fa-brands fa-atlassian",
            "fa-brands fa-audible",
            "fa-brands fa-autoprefixer",
            "fa-brands fa-avianex",
            "fa-brands fa-aviato",
            "fa-brands fa-aws",
            "fa-brands fa-bandcamp",
            "fa-brands fa-battle-net",
            "fa-brands fa-behance",
            "fa-brands fa-behance-square",
            "fa-brands fa-bilibili",
            "fa-brands fa-bimobject",
            "fa-brands fa-bitbucket",
            "fa-brands fa-bitcoin",
            "fa-brands fa-bity",
            "fa-brands fa-black-tie",
            "fa-brands fa-blackberry",
            "fa-brands fa-blogger",
            "fa-brands fa-blogger-b",
            "fa-brands fa-bluetooth",
            "fa-brands fa-bluetooth-b",
            "fa-brands fa-bootstrap",
            "fa-brands fa-bots",
            "fa-brands fa-brave",
            "fa-brands fa-brave-reverse",
            "fa-brands fa-btc",
            "fa-brands fa-buffer",
            "fa-brands fa-buromobelexperte",
            "fa-brands fa-buy-n-large",
            "fa-brands fa-buysellads",
            "fa-brands fa-canadian-maple-leaf",
            "fa-brands fa-cc-amazon-pay",
            "fa-brands fa-cc-amex",
            "fa-brands fa-cc-apple-pay",
            "fa-brands fa-cc-diners-club",
            "fa-brands fa-cc-discover",
            "fa-brands fa-cc-jcb",
            "fa-brands fa-cc-mastercard",
            "fa-brands fa-cc-paypal",
            "fa-brands fa-cc-stripe",
            "fa-brands fa-cc-visa",
            "fa-brands fa-centercode",
            "fa-brands fa-centos",
            "fa-brands fa-chrome",
            "fa-brands fa-chromecast",
            "fa-brands fa-cloudflare",
            "fa-brands fa-cloudscale",
            "fa-brands fa-cloudsmith",
            "fa-brands fa-cloudversify",
            "fa-brands fa-cmplid",
            "fa-brands fa-codepen",
            "fa-brands fa-codiepie",
            "fa-brands fa-confluence",
            "fa-brands fa-connectdevelop",
            "fa-brands fa-contao",
            "fa-brands fa-cotton-bureau",
            "fa-brands fa-cpanel",
            "fa-brands fa-creative-commons",
            "fa-brands fa-creative-commons-by",
            "fa-brands fa-creative-commons-nc",
            "fa-brands fa-creative-commons-nc-eu",
            "fa-brands fa-creative-commons-nc-jp",
            "fa-brands fa-creative-commons-nd",
            "fa-brands fa-creative-commons-pd",
            "fa-brands fa-creative-commons-pd-alt",
            "fa-brands fa-creative-commons-remix",
            "fa-brands fa-creative-commons-sa",
            "fa-brands fa-creative-commons-sampling",
            "fa-brands fa-creative-commons-sampling-plus",
            "fa-brands fa-creative-commons-share",
            "fa-brands fa-creative-commons-zero",
            "fa-brands fa-critical-role",
            "fa-brands fa-css3",
            "fa-brands fa-css3-alt",
            "fa-brands fa-cuttlefish",
            "fa-brands fa-d-and-d",
            "fa-brands fa-d-and-d-beyond",
            "fa-brands fa-dailymotion",
            "fa-brands fa-dashcube",
            "fa-brands fa-debian",
            "fa-brands fa-deezer",
            "fa-brands fa-delicious",
            "fa-brands fa-deploydog",
            "fa-brands fa-deskpro",
            "fa-brands fa-dev",
            "fa-brands fa-deviantart",
            "fa-brands fa-dhl",
            "fa-brands fa-diaspora",
            "fa-brands fa-digg",
            "fa-brands fa-digital-ocean",
            "fa-brands fa-discord",
            "fa-brands fa-discourse",
            "fa-brands fa-dochub",
            "fa-brands fa-docker",
            "fa-brands fa-draft2digital",
            "fa-brands fa-dribbble",
            "fa-brands fa-dribbble-square",
            "fa-brands fa-dropbox",
            "fa-brands fa-drupal",
            "fa-brands fa-dyalog",
            "fa-brands fa-earlybirds",
            "fa-brands fa-ebay",
            "fa-brands fa-edge",
            "fa-brands fa-edge-legacy",
            "fa-brands fa-elementor",
            "fa-brands fa-ello",
            "fa-brands fa-ember",
            "fa-brands fa-empire",
            "fa-brands fa-envira",
            "fa-brands fa-erlang",
            "fa-brands fa-ethereum",
            "fa-brands fa-etsy",
            "fa-brands fa-evernote",
            "fa-brands fa-expeditedssl",
            "fa-brands fa-facebook",
            "fa-brands fa-facebook-f",
            "fa-brands fa-facebook-messenger",
            "fa-brands fa-facebook-square",
            "fa-brands fa-fantasy-flight-games",
            "fa-brands fa-fedex",
            "fa-brands fa-fedora",
            "fa-brands fa-figma",
            "fa-brands fa-firefox",
            "fa-brands fa-firefox-browser",
            "fa-brands fa-first-order",
            "fa-brands fa-first-order-alt",
            "fa-brands fa-firstdraft",
            "fa-brands fa-flickr",
            "fa-brands fa-flipboard",
            "fa-brands fa-fly",
            "fa-brands fa-font-awesome",
            "fa-brands fa-font-awesome-alt",
            "fa-brands fa-font-awesome-flag",
            "fa-brands fa-font-awesome-logo-full",
            "fa-brands fa-fonticons",
            "fa-brands fa-fonticons-fi",
            "fa-brands fa-fort-awesome",
            "fa-brands fa-fort-awesome-alt",
            "fa-brands fa-forumbee",
            "fa-brands fa-foursquare",
            "fa-brands fa-free-code-camp",
            "fa-brands fa-freebsd",
            "fa-brands fa-fulcrum",
            "fa-brands fa-galactic-republic",
            "fa-brands fa-galactic-senate",
            "fa-brands fa-get-pocket",
            "fa-brands fa-gg",
            "fa-brands fa-gg-circle",
            "fa-brands fa-git",
            "fa-brands fa-git-alt",
            "fa-brands fa-git-square",
            "fa-brands fa-github",
            "fa-brands fa-github-alt",
            "fa-brands fa-github-square",
            "fa-brands fa-gitkraken",
            "fa-brands fa-gitlab",
            "fa-brands fa-gitlab-square",
            "fa-brands fa-gitter",
            "fa-brands fa-glide",
            "fa-brands fa-glide-g",
            "fa-brands fa-gofore",
            "fa-brands fa-golang",
            "fa-brands fa-goodreads",
            "fa-brands fa-goodreads-g",
            "fa-brands fa-google",
            "fa-brands fa-google-drive",
            "fa-brands fa-google-pay",
            "fa-brands fa-google-play",
            "fa-brands fa-google-plus",
            "fa-brands fa-google-plus-g",
            "fa-brands fa-google-plus-square",
            "fa-brands fa-google-scholar",
            "fa-brands fa-google-wallet",
            "fa-brands fa-gratipay",
            "fa-brands fa-grav",
            "fa-brands fa-gripfire",
            "fa-brands fa-grunt",
            "fa-brands fa-guilded",
            "fa-brands fa-gulp",
            "fa-brands fa-hacker-news",
            "fa-brands fa-hacker-news-square",
            "fa-brands fa-hackerrank",
            "fa-brands fa-hashnode",
            "fa-brands fa-hips",
            "fa-brands fa-hire-a-helper",
            "fa-brands fa-hive",
            "fa-brands fa-hooli",
            "fa-brands fa-hornbill",
            "fa-brands fa-hotjar",
            "fa-brands fa-houzz",
            "fa-brands fa-html5",
            "fa-brands fa-hubspot",
            "fa-brands fa-ideal",
            "fa-brands fa-imdb",
            "fa-brands fa-innosoft",
            "fa-brands fa-instagram",
            "fa-brands fa-instagram-square",
            "fa-brands fa-instalod",
            "fa-brands fa-intercom",
            "fa-brands fa-internet-explorer",
            "fa-brands fa-invision",
            "fa-brands fa-ioxhost",
            "fa-brands fa-itch-io",
            "fa-brands fa-itunes",
            "fa-brands fa-itunes-note",
            "fa-brands fa-java",
            "fa-brands fa-jedi-order",
            "fa-brands fa-jenkins",
            "fa-brands fa-jira",
            "fa-brands fa-joget",
            "fa-brands fa-joomla",
            "fa-brands fa-js",
            "fa-brands fa-js-square",
            "fa-brands fa-jsfiddle",
            "fa-brands fa-kaggle",
            "fa-brands fa-keybase",
            "fa-brands fa-keycdn",
            "fa-brands fa-kickstarter",
            "fa-brands fa-kickstarter-k",
            "fa-brands fa-korvue",
            "fa-brands fa-laravel",
            "fa-brands fa-lastfm",
            "fa-brands fa-lastfm-square",
            "fa-brands fa-leanpub",
            "fa-brands fa-less",
            "fa-brands fa-letterboxd",
            "fa-brands fa-line",
            "fa-brands fa-linkedin",
            "fa-brands fa-linkedin-in",
            "fa-brands fa-linode",
            "fa-brands fa-linux",
            "fa-brands fa-lyft",
            "fa-brands fa-magento",
            "fa-brands fa-mailchimp",
            "fa-brands fa-mandalorian",
            "fa-brands fa-markdown",
            "fa-brands fa-mastodon",
            "fa-brands fa-maxcdn",
            "fa-brands fa-mdb",
            "fa-brands fa-medapps",
            "fa-brands fa-medium",
            "fa-brands fa-medium-m",
            "fa-brands fa-medrt",
            "fa-brands fa-meetup",
            "fa-brands fa-megaport",
            "fa-brands fa-mendeley",
            "fa-brands fa-meta",
            "fa-brands fa-microblog",
            "fa-brands fa-microsoft",
            "fa-brands fa-mintbit",
            "fa-brands fa-mix",
            "fa-brands fa-mixcloud",
            "fa-brands fa-mixer",
            "fa-brands fa-mizuni",
            "fa-brands fa-modx",
            "fa-brands fa-monero",
            "fa-brands fa-napster",
            "fa-brands fa-neos",
            "fa-brands fa-nfc-directional",
            "fa-brands fa-nfc-symbol",
            "fa-brands fa-nimblr",
            "fa-brands fa-node",
            "fa-brands fa-node-js",
            "fa-brands fa-npm",
            "fa-brands fa-ns8",
            "fa-brands fa-nutritionix",
            "fa-brands fa-octopus-deploy",
            "fa-brands fa-odnoklassniki",
            "fa-brands fa-odnoklassniki-square",
            "fa-brands fa-odysee",
            "fa-brands fa-old-republic",
            "fa-brands fa-opencart",
            "fa-brands fa-openid",
            "fa-brands fa-opensuse",
            "fa-brands fa-opera",
            "fa-brands fa-optin-monster",
            "fa-brands fa-orcid",
            "fa-brands fa-osi",
            "fa-brands fa-padlet",
            "fa-brands fa-page4",
            "fa-brands fa-pagelines",
            "fa-brands fa-palfed",
            "fa-brands fa-patreon",
            "fa-brands fa-paypal",
            "fa-brands fa-perbyte",
            "fa-brands fa-periscope",
            "fa-brands fa-phabricator",
            "fa-brands fa-phoenix-framework",
            "fa-brands fa-phoenix-squadron",
            "fa-brands fa-php",
            "fa-brands fa-pied-piper",
            "fa-brands fa-pied-piper-alt",
            "fa-brands fa-pied-piper-hat",
            "fa-brands fa-pied-piper-pp",
            "fa-brands fa-pied-piper-square",
            "fa-brands fa-pinterest",
            "fa-brands fa-pinterest-p",
            "fa-brands fa-pinterest-square",
            "fa-brands fa-pix",
            "fa-brands fa-pixiv",
            "fa-brands fa-playstation",
            "fa-brands fa-product-hunt",
            "fa-brands fa-pushed",
            "fa-brands fa-python",
            "fa-brands fa-qq",
            "fa-brands fa-quinscape",
            "fa-brands fa-quora",
            "fa-brands fa-r-project",
            "fa-brands fa-raspberry-pi",
            "fa-brands fa-ravelry",
            "fa-brands fa-react",
            "fa-brands fa-reacteurope",
            "fa-brands fa-readme",
            "fa-brands fa-rebel",
            "fa-brands fa-red-river",
            "fa-brands fa-reddit",
            "fa-brands fa-reddit-alien",
            "fa-brands fa-reddit-square",
            "fa-brands fa-redhat",
            "fa-brands fa-rendact",
            "fa-brands fa-renren",
            "fa-brands fa-replyd",
            "fa-brands fa-researchgate",
            "fa-brands fa-resolving",
            "fa-brands fa-rev",
            "fa-brands fa-rocketchat",
            "fa-brands fa-rockrms",
            "fa-brands fa-rust",
            "fa-brands fa-safari",
            "fa-brands fa-salesforce",
            "fa-brands fa-sass",
            "fa-brands fa-schlix",
            "fa-brands fa-screenpal",
            "fa-brands fa-scribd",
            "fa-brands fa-searchengin",
            "fa-brands fa-sellcast",
            "fa-brands fa-sellsy",
            "fa-brands fa-servicestack",
            "fa-brands fa-shirtsinbulk",
            "fa-brands fa-shoelace",
            "fa-brands fa-shopify",
            "fa-brands fa-shopware",
            "fa-brands fa-signal-messenger",
            "fa-brands fa-simplybuilt",
            "fa-brands fa-sistrix",
            "fa-brands fa-sith",
            "fa-brands fa-sitrox",
            "fa-brands fa-sketch",
            "fa-brands fa-skyatlas",
            "fa-brands fa-skype",
            "fa-brands fa-slack",
            "fa-brands fa-slack-hash",
            "fa-brands fa-slideshare",
            "fa-brands fa-snapchat",
            "fa-brands fa-snapchat-ghost",
            "fa-brands fa-snapchat-square",
            "fa-brands fa-soundcloud",
            "fa-brands fa-sourcetree",
            "fa-brands fa-space-awesome",
            "fa-brands fa-speakap",
            "fa-brands fa-speaker-deck",
            "fa-brands fa-spotify",
            "fa-brands fa-square-behance",
            "fa-brands fa-square-dribbble",
            "fa-brands fa-square-facebook",
            "fa-brands fa-square-font-awesome",
            "fa-brands fa-square-font-awesome-stroke",
            "fa-brands fa-square-git",
            "fa-brands fa-square-github",
            "fa-brands fa-square-gitlab",
            "fa-brands fa-square-google-plus",
            "fa-brands fa-square-hacker-news",
            "fa-brands fa-square-instagram",
            "fa-brands fa-square-js",
            "fa-brands fa-square-lastfm",
            "fa-brands fa-square-letterboxd",
            "fa-brands fa-square-odnoklassniki",
            "fa-brands fa-square-pied-piper",
            "fa-brands fa-square-pinterest",
            "fa-brands fa-square-reddit",
            "fa-brands fa-square-snapchat",
            "fa-brands fa-square-steam",
            "fa-brands fa-square-threads",
            "fa-brands fa-square-tumblr",
            "fa-brands fa-square-twitter",
            "fa-brands fa-square-viadeo",
            "fa-brands fa-square-vimeo",
            "fa-brands fa-square-whatsapp",
            "fa-brands fa-square-x-twitter",
            "fa-brands fa-square-xing",
            "fa-brands fa-square-youtube",
            "fa-brands fa-squarespace",
            "fa-brands fa-stack-exchange",
            "fa-brands fa-stack-overflow",
            "fa-brands fa-stackpath",
            "fa-brands fa-staylinked",
            "fa-brands fa-steam",
            "fa-brands fa-steam-square",
            "fa-brands fa-steam-symbol",
            "fa-brands fa-sticker-mule",
            "fa-brands fa-strava",
            "fa-brands fa-stripe",
            "fa-brands fa-stripe-s",
            "fa-brands fa-stubber",
            "fa-brands fa-studiovinari",
            "fa-brands fa-stumbleupon",
            "fa-brands fa-stumbleupon-circle",
            "fa-brands fa-superpowers",
            "fa-brands fa-supple",
            "fa-brands fa-suse",
            "fa-brands fa-swift",
            "fa-brands fa-symfony",
            "fa-brands fa-teamspeak",
            "fa-brands fa-telegram",
            "fa-brands fa-telegram-plane",
            "fa-brands fa-tencent-weibo",
            "fa-brands fa-the-red-yeti",
            "fa-brands fa-themeco",
            "fa-brands fa-themeisle",
            "fa-brands fa-think-peaks",
            "fa-brands fa-threads",
            "fa-brands fa-tiktok",
            "fa-brands fa-trade-federation",
            "fa-brands fa-trello",
            "fa-brands fa-tumblr",
            "fa-brands fa-tumblr-square",
            "fa-brands fa-twitch",
            "fa-brands fa-twitter",
            "fa-brands fa-twitter-square",
            "fa-brands fa-typo3",
            "fa-brands fa-uber",
            "fa-brands fa-ubuntu",
            "fa-brands fa-uikit",
            "fa-brands fa-umbraco",
            "fa-brands fa-uncharted",
            "fa-brands fa-uniregistry",
            "fa-brands fa-unity",
            "fa-brands fa-unsplash",
            "fa-brands fa-untappd",
            "fa-brands fa-ups",
            "fa-brands fa-upwork",
            "fa-brands fa-usb",
            "fa-brands fa-usps",
            "fa-brands fa-ussunnah",
            "fa-brands fa-vaadin",
            "fa-brands fa-viacoin",
            "fa-brands fa-viadeo",
            "fa-brands fa-viadeo-square",
            "fa-brands fa-viber",
            "fa-brands fa-vimeo",
            "fa-brands fa-vimeo-square",
            "fa-brands fa-vimeo-v",
            "fa-brands fa-vine",
            "fa-brands fa-vk",
            "fa-brands fa-vnv",
            "fa-brands fa-vuejs",
            "fa-brands fa-watchman-monitoring",
            "fa-brands fa-waze",
            "fa-brands fa-webflow",
            "fa-brands fa-weebly",
            "fa-brands fa-weibo",
            "fa-brands fa-weixin",
            "fa-brands fa-whatsapp",
            "fa-brands fa-whatsapp-square",
            "fa-brands fa-whmcs",
            "fa-brands fa-wikipedia-w",
            "fa-brands fa-windows",
            "fa-brands fa-wirsindhandwerk",
            "fa-brands fa-wix",
            "fa-brands fa-wizards-of-the-coast",
            "fa-brands fa-wodu",
            "fa-brands fa-wolf-pack-battalion",
            "fa-brands fa-wordpress",
            "fa-brands fa-wordpress-simple",
            "fa-brands fa-wpbeginner",
            "fa-brands fa-wpexplorer",
            "fa-brands fa-wpforms",
            "fa-brands fa-wpressr",
            "fa-brands fa-wsh",
            "fa-brands fa-x-twitter",
            "fa-brands fa-xbox",
            "fa-brands fa-xing",
            "fa-brands fa-xing-square",
            "fa-brands fa-y-combinator",
            "fa-brands fa-yahoo",
            "fa-brands fa-yammer",
            "fa-brands fa-yandex",
            "fa-brands fa-yandex-international",
            "fa-brands fa-yarn",
            "fa-brands fa-yelp",
            "fa-brands fa-yoast",
            "fa-brands fa-youtube",
            "fa-brands fa-youtube-square",
            "fa-brands fa-zhihu"
        ];
    }
}
