<?php

/**
 * Delete all user data (and account)
 *
 * Send confirmation mail.
 *
 * @return void
 * @throws \Exception
 */

use QUI\GDPR\DataRequest\Handler;
use QUI\Utils\Security\Orthos;
use QUI\GDPR\Permissions;

QUI::$Ajax->registerFunction(
    'package_quiqqer_gdpr_ajax_backend_deleteUserData',
    function ($userId) {
        try {
            $User = QUI::getUsers()->get(Orthos::clear($userId));
            Handler::deleteUserData($User);
        } catch (\Exception $Exception) {
            QUI\System\Log::writeException($Exception);

            throw new \QUI\Exception([
                'quiqqer/gdpr',
                'exception.ajax.backend.deleteUserData'
            ]);
        }

        QUI::getMessagesHandler()->addSuccess(
            QUI::getLocale()->get(
                'quiqqer/gdpr',
                'message.ajax.backend.deleteUserData.success',
                [
                    'userId'   => $User->getId(),
                    'userName' => $User->getName()
                ]
            )
        );
    },
    ['userId'],
    [
        'Permission::checkAdminUser',
        Permissions::DATA_REQUEST_DELETE_USER
    ]
);
