<?php

define('QUIQQER_SYSTEM', true);
define('QUIQQER_AJAX', true);

require_once dirname(__FILE__, 5) . '/header.php';

use QUI\GDPR\DataRequest\Handler;
use QUI\Utils\Security\Orthos;
use QUI\Permissions\Permission;
use QUI\GDPR\Permissions;

$User = QUI::getUserBySession();

if (!$User->canUseBackend()) {
    exit;
}

//if (!\QUI\Permissions\Permission::hasPermission(Provider::PERMISSION_PROCESSES_XML_DOWNLOAD, $User)) {
//    exit;
//}

if (empty($_REQUEST['uid'])) {
    exit;
}

$User = QUI::getUsers()->get(Orthos::clear($_REQUEST['uid']));

Permission::checkPermission(Permissions::DATA_REQUEST_CREATE_REPORT);

try {
    $pdfFile = Handler::getDataRequestPdf($User);

    if (!$pdfFile) {
        exit;
    }

    $Locale = $User->getLocale();

    QUI\Utils\System\File::send(
        $pdfFile,
        0,
        $Locale->get(
            'quiqqer/gdpr',
            'DataRequest.filename',
            [
                'userId' => $User->getId(),
                'date' => $Locale->formatDate(\time())
            ]
        )
    );

    \unlink($pdfFile);
} catch (\Exception $Exception) {
    QUI\System\Log::writeException($Exception);
}
