/**
 * GDPR ChecklistPanel
 *
 * @module package/quiqqer/gdpr/bin/controls/ChecklistPanel
 * @author www.pcsg.de (Jan Wennrich)
 *
 */
define('package/quiqqer/gdpr/bin/controls/ChecklistPanel', [

    'qui/QUI',
    'qui/controls/desktop/Panel',

    'package/quiqqer/gdpr/bin/ChecklistManager',

    'Locale',

    'css!package/quiqqer/gdpr/bin/controls/ChecklistPanel.css'
], function (QUI, QUIPanel, ChecklistManager, QUILocale) {
    "use strict";

    var lg = 'quiqqer/gdpr';

    return new Class({

        Extends: QUIPanel,
        Type   : 'package/quiqqer/gdpr/bin/controls/ChecklistPanel',

        Binds: [
            'onCheckboxChange',
            'initialize',
            'getCurrentProject',
            'getCheckboxes',
            'applyCheckboxChangeListeners',
            'loadData',
            '$onCreate',
            '$onInject',
            '$onResize'
        ],

        $ProjectSelect: null,

        initialize: function (options) {
            this.setAttributes({
                icon : 'fa fa-circle',
                title: QUILocale.get(lg, 'checklist.title')
            });

            this.parent(options);

            this.addEvents({
                onCreate: this.$onCreate,
                onResize: this.$onResize,
                onInject: this.$onInject
            });
        },

        /**
         * event : on create
         */
        $onCreate: function () {

        },


        /**
         * event : on inject
         */
        $onInject: function () {
            var self = this;

            require(['controls/projects/Select'], function (ProjectSelect) {
                self.$ProjectSelect = new ProjectSelect({
                    emptyselect: false,
                    langSelect : false,
                    events     : {
                        onChange: self.loadData
                    }
                });

                self.addButton(self.$ProjectSelect);
            });
        },


        /**
         * event : on resize
         */
        $onResize: function () {

        },

        getCurrentProject: function () {
            return this.$ProjectSelect.getValue();
        },

        /**
         * Load the grid data for the currently selected calendar
         */
        loadData: function () {
            this.Loader.show();

            var self = this;

            ChecklistManager.getHtml(this.getCurrentProject()).then(function (html) {
                self.getContent().set('html', html);
                self.applyCheckboxChangeListeners();
                self.Loader.hide();
            });
        },

        getCheckboxes: function () {
            return this.getContent().querySelectorAll('#gdpr-checklist .gdpr-checklist-item input');
        },

        applyCheckboxChangeListeners: function () {
            var checkboxes = this.getCheckboxes();

            for (var i = 0; i < checkboxes.length; i++) {
                checkboxes[i].addEventListener('change', this.onCheckboxChange);
            }
        },

        onCheckboxChange: function (Event) {
            var self   = this,
                Target = Event.target,
                items  = {};

            items[Target.name] = Target.checked;

            this.Loader.show();
            ChecklistManager.saveItems(this.getCurrentProject(), items).then(function () {
                self.Loader.hide();
            });
        }
    });
});
