(function () {
    "use strict";

    /**
     * Check if we're ready to load the banner.
     * We're ready, if MooTools is loaded since qui/QUI requires it.
     * If the method 'whenQuiLoaded' exist, we're in a new template and have to load MooTools manually.
     * If the method does not exist, we're in an old template and MooTools is already loaded.
     *
     * @returns {Promise}
     */
    function readyToLoad() {
        // New Template -> MooTools may not be loaded yet (is loaded async)
        if (typeof whenQuiLoaded === 'function') {
            return new Promise(function (resolve) {
                if (typeof MooTools !== 'undefined') { 
                    return resolve(MooTools);
                }

                require(['MooTools'], resolve);
            });
        }

        // Old Template -> MooTools is already loaded (synchronously)
        return Promise.resolve();
    }

    function initCookieBannerLoader() {
        require([
            'qui/QUI',
            'Ajax'
        ], function (QUI, QUIAjax) {
            /**
             * Checks if the cookiebanner has to be loaded.
             * Response contains the control's HTML.
             */
            QUIAjax.get('package_quiqqer_gdpr_ajax_initCookieBannerLoader', function (response) {
                // If we don't get a response all necessary cookies were already accepted
                if (!response) {
                    if (window.localStorage) {
                        // User already interacted with the banner so set this value for the future.
                        window.localStorage.setItem(GDPR.storageKeys.hideBanner, '1');
                    }

                    return;
                }

                // Create a wrapper to embed the control in
                var CookieConsent = document.createElement('div');
                CookieConsent.id = 'quiqqer-cookieconsent-wrapper';
                CookieConsent.dataset.nosnippet = 'data-nosnippet'; // Prevents the cookie banner (content) from appearing in Google search results
                CookieConsent.innerHTML = response;

                // Append the wrapper to the end of the body
                document.body.appendChild(CookieConsent);

                // Parse the control's HTML so data-qui attributes are interpreted & executed
                QUI.parse(CookieConsent);
            }, {
                'package': 'quiqqer/gdpr',
                lang: QUIQQER_PROJECT.lang
            });
        });
    }

    readyToLoad().then(initCookieBannerLoader);
})();
