<?php

namespace QUI\GDPR\DataRequest;

use QUI\Interfaces\Users\User as UserInterface;
use QUI\Locale as QUILocale;

/**
 * Class AbstractDataProvider
 *
 * Base abstract class for all GDPR data providers.
 */
abstract class AbstractDataProvider implements DataProviderInterface
{
    protected UserInterface $user;
    protected QUILocale $locale;

    /**
     * @inheritDoc
     */
    public function setUser(UserInterface $user): void
    {
        $this->user = $user;
    }

    /**
     * @inheritDoc
     */
    public function setLocale(QUILocale $locale): void
    {
        $this->locale = $locale;
    }
}
