<?php

namespace QUI\GDPR\DataRequest;

class UserDataField
{
    /**
     * Flag that indicates if data of this field are always included in the GDPR report.
     *
     * If set to false (default), the data will only be included if it is different from other user data.
     *
     * @var bool
     */
    public bool $alwaysInclude = false;

    /**
     * @param string $title
     * @param string|array<int,string|UserDataField|UserDataFieldValue>|null $data - Can be a string that represents one value or a UserDataField itself
     * that holds multiple title => value pairs; IMPORTANT: only ONE UserDataField layer is supported in the template!
     *
     * If $data is NULL, only the $title is displayed
     */
    public function __construct(public string $title, public readonly string | array | null $data = null)
    {
    }
}
