<script src="{$smarty.const.URL_OPT_DIR}quiqqer/gdpr/bin/controls/CookieConsent.js"
        data-qui="package/quiqqer/gdpr/bin/controls/CookieConsent"></script>

<script type='text/javascript'>
    window.GDPR = {
        settings: {
            showBannerOnCookieChange: '{$showBannerOnCookieChange}',
            essentialCookieCategoryName: '{$essentialCookieCategoryName}'
        },

        storageKeys: {
            hideBanner: 'quiqqer-gdpr-hideBanner',
            acceptedCookieCategories: 'quiqqer-gdpr-accepted-cookie-categories',
            acceptedCookiesHash: 'quiqqer-gdpr-accepted-cookies-hash'
        },

        availableCookieCategories: '{$availableCookieCategories}',

        /**
         * Returns a hash of all cookies registered in the system
         *
         * {literal}
         * @return {string}
         * {/literal}
         */
        getCookiesHash: function () {
            return '{$cookiesHash}';
        },

        /**
         * Returns if the cookies the user accepted are outdated.
         *
         * This is the case if the hash of the user's accepted cookies differs from the current hash of all cookies.
         *
         * {literal}
         * @return {boolean}
         * {/literal}
         */
        areAcceptedCookiesOutdated: function () {
            return window.localStorage.getItem(GDPR.storageKeys.acceptedCookiesHash) !== GDPR.getCookiesHash();
        },

        /**
         * Returns if the cookie-banner should be displayed.
         *
         * It considers the user's previous choices and the system's cookie settings.
         *
         * {literal}
         * @return {boolean}
         * {/literal}
         */
        shouldBannerBeDisplayed: function () {
            // If LocalStorage isn't available we can't know if user accepted cookies -> show banner
            if (!window.localStorage) {
                return true;
            }

            // check url params
            const locUrl = new URL(window.location);

            if (locUrl.searchParams.has('acceptedCookieCategories') || locUrl.searchParams.has('acceptedCookieBanner')) {
                if (typeof this.availableCookieCategories === 'string') {
                    this.availableCookieCategories = JSON.parse(this.availableCookieCategories);
                }

                if (!Array.isArray(this.availableCookieCategories)) {
                    this.availableCookieCategories = [];
                }

                let i, len, category;
                let accepted = ['essential'];

                if (locUrl.searchParams.has('acceptedCookieCategories')) {
                    accepted = locUrl.searchParams.get('acceptedCookieCategories').split(',');
                    accepted.push('essential');
                }

                const available = this.availableCookieCategories;
                let categories = [];

                if (locUrl.searchParams.has('acceptedCookieBanner') || locUrl.searchParams.has('acceptedCookieCategories')) {
                    categories.push('essential');
                }

                if (accepted.indexOf('all') !== -1) {
                    categories = available;
                } else {
                    for (i = 0, len = accepted.length; i < len; i++) {
                        category = accepted[i];

                        if (available.indexOf(category) === -1) {
                            categories.push(category);
                        }
                    }
                }

                window.localStorage.setItem('quiqqer-cookies-accepted-timestamp', Date.now().toString());
                window.localStorage.setItem(GDPR.storageKeys.hideBanner, '1');
                window.localStorage.setItem(GDPR.storageKeys.acceptedCookiesHash, GDPR.getCookiesHash());
                window.localStorage.setItem(GDPR.storageKeys.acceptedCookieCategories, JSON.stringify(categories));
            }

            // Do we care about changing cookies AND are the accepted cookies outdated -> show banner
            if (this.settings.showBannerOnCookieChange && this.areAcceptedCookiesOutdated()) {
                return true;
            }

            // Did the user accept cookies already? -> don't show banner
            if (window.localStorage.getItem(GDPR.storageKeys.hideBanner)) {
                return false;
            }

            return true;
        },

        /**
         * Returns if the user already accepted a given cookie category.
         *
         * @param category
         *
         * {literal}
         * @return {boolean}
         * {/literal}
         */
        isCookieCategoryAccepted: function (category) {
            if (category === this.settings.essentialCookieCategoryName) {
                return true;
            }

            try {
                var acceptedCookieCategories = JSON.parse(
                    window.localStorage.getItem(GDPR.storageKeys.acceptedCookieCategories)
                );
            } catch (e) {
                var acceptedCookieCategories = false;
            }

            if (!acceptedCookieCategories || acceptedCookieCategories.indexOf(category) === -1) {
                return false;
            }

            return true;
        },

        /**
         * Returns a promise that resolves when the user accepts a given cookie category.
         *
         * The promise resolves immediately, if the category was already accepted.
         *
         * @param category
         *
         * {literal}
         * @return {Promise}
         * {/literal}
         */
        waitForCookieCategoryAcceptance: function (category) {
            var self = this;
            return new Promise(function (resolve) {
                if (self.isCookieCategoryAccepted(category)) {
                    resolve();

                    return;
                }

                // wait for QUI to be loaded
                var loadQUI = function () {
                    return Promise.resolve();
                };

                if (typeof whenQuiLoaded === 'function') {
                    loadQUI = whenQuiLoaded;
                }

                loadQUI().then(function () {
                    require(['qui/QUI'], function (QUI) {
                        QUI.addEvent('onCookieCategoriesAccepted', function () {
                            if (self.isCookieCategoryAccepted(category)) {
                                resolve();

                                return;
                            }
                        });
                    });
                });
            });
        },

        waitForCookieCategoriesAcceptance: function (categories) {
            var self = this;

            var CategoryAcceptancePromises = categories.map(function (category) {
                return self.waitForCookieCategoryAcceptance(category)
            });

            return Promise.all(CategoryAcceptancePromises);
        }
    };

    if (GDPR.shouldBannerBeDisplayed()) {
        if (typeof require === 'function') {
            require([URL_OPT_DIR + 'quiqqer/gdpr/bin/cookieBannerLoader.js']);
        } else if (typeof whenQuiLoaded === 'function') {
            whenQuiLoaded().then(function () {
                require([URL_OPT_DIR + 'quiqqer/gdpr/bin/cookieBannerLoader.js']);
            });
        } else {

            (function () {
                var cr;
                cr = function () {
                    if (typeof require === 'function') {
                        return Promise.resolve(true);
                    }

                    return new Promise(function (resolve) {
                        setTimeout(function () {
                            cr().then(resolve);
                        }, 100);
                    });
                }

                cr().then(function () {
                    require([URL_OPT_DIR + 'quiqqer/gdpr/bin/cookieBannerLoader.js']);
                });
            })();

        }
    }
</script>
