/**
 * Display user downloads manager in user panel
 *
 * @module package/quiqqer/gdpr/bin/controls/user/GdprActionsCategory
 * @author www.pcsg.de (Patrick Müller)
 */
define('package/quiqqer/gdpr/bin/controls/user/GdprActionsCategory', [

    'qui/controls/Control',
    'utils/Controls',

    'package/quiqqer/gdpr/bin/controls/user/GdprActions',

    'css!package/quiqqer/gdpr/bin/controls/user/GdprActionsCategory.css'

], function (QUIControl, QUIControlUtils, GdprActions) {
    "use strict";

    return new Class({

        Extends: QUIControl,
        Type   : 'package/quiqqer/gdpr/bin/controls/user/GdprActionsCategory',

        Binds: [
            '$onInject',
            '$onResize'
        ],

        initialize: function (options) {
            this.parent(options);

            this.$Manager = null;

            this.addEvents({
                onInject: this.$onInject,
                onImport: this.$onImport
            });
        },

        /**
         * Event: onResize
         */
        $onResize: function () {
            if (this.$Manager) {
                this.$Manager.resize();
            }
        },

        /**
         * Event: onImport
         */
        $onImport: function () {
            var Input = this.getElm();
            var Table = Input.getParent('table');

            this.$Elm = new Element('div', {
                'class': 'quiqqer-gdpr-user-actions-container'
            }).inject(Table, 'before');

            Table.destroy();

            this.$onInject();
        },

        /**
         * Event: onInject
         */
        $onInject: function () {
            var self = this;

            // if control is injected in a panel, register onResize event
            QUIControlUtils.getControlByElement(
                this.$Elm.getParent('.qui-panel')
            ).then(function (Panel) {

                Panel.addEvent('onResize', self.$onResize);

                var userId;

                switch (Panel.getType()) {
                    case 'package/quiqqer/customer/bin/backend/controls/customer/Panel':
                        userId = Panel.getAttribute('userId');
                        //
                        //var Form = self.$Elm.getParent('form');
                        //
                        //Form.setStyle('height', '100%');
                        break;

                    default:
                        userId = Panel.getUser().getId();
                }

                self.$Manager = new GdprActions({
                    userId: userId
                }).inject(self.$Elm);
            }, function () {
                // do nothing if no panel found
            });

            this.$Elm.getParent('form').setStyles({
                float : 'left',
                height: '100%',
                width : '100%'
            });

            this.$Elm.addClass('quiqqer-gdpr-user-actions-container');
        }
    });
});
