<?php

/**
 * @author PCSG (Jan Wennrich)
 */

namespace QUI\GDPR\Cookies;

use QUI;
use QUI\GDPR\CookieInterface;

use function sprintf;

/**
 * Class QuiqqerSessionCookie
 *
 * @package QUI\GDPR\Cookies
 */
class QuiqqerSessionCookie implements CookieInterface
{
    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return QUI::conf('session', 'name');
    }

    /**
     * @inheritDoc
     */
    public function getOrigin(): string
    {
        return QUI::getRequest()->getHost();
    }

    /**
     * @inheritDoc
     */
    public function getPurpose(): string
    {
        return QUI::getLocale()->get('quiqqer/gdpr', 'cookie.quiqqer.purpose');
    }

    /**
     * @inheritDoc
     */
    public function getLifetime(): string
    {
        return sprintf(
            '%d %s',
            QUI::conf('session', 'max_life_time'),
            QUI::getLocale()->get('quiqqer/core', 'seconds')
        );
    }

    /**
     * @inheritDoc
     */
    public function getCategory(): string
    {
        return static::COOKIE_CATEGORY_ESSENTIAL;
    }
}
