<style>
    h1 {
        font-size: 13pt;
    }

    h2 {
        font-size: 12pt;
    }

    h3 {
        font-size: 9pt;
    }

    table {
        border-collapse: collapse;
        width: 100%;
        page-break-inside: auto;
    }

    .data-request-categories-entry-dataFields-row-table__title {
        font-weight: bold;
        background: #eee;
        font-size: 9pt;
        padding-top: 1.5mm;
        padding-bottom: 1.5mm;
        padding-right: 3mm;
        border-bottom: 1px solid #ccc;
    }

    table[data-level="1"] .data-request-categories-entry-dataFields-row-table__title {
        padding-left: 3mm;
    }

    table[data-level="2"] .data-request-categories-entry-dataFields-row-table__title,
    table[data-level="2"] > tbody > tr > td:first-child {
        padding-left: 5mm;
    }

    table[data-level="3"] .data-request-categories-entry-dataFields-row-table__title,
    table[data-level="3"] > tbody > tr > td:first-child {
        padding-left: 10mm;
    }

    table[data-level="4"] .data-request-categories-entry-dataFields-row-table__title,
    table[data-level="4"] > tbody > tr > td:first-child {
        padding-left: 15mm;
    }

    table[data-level="5"] > tbody > tr > td:first-child {
        padding-left: 20mm;
    }

    td {
        vertical-align: top;
        padding: 1.5mm 3mm;
    }

    td:first-child {
        width: 10cm;
        webkit-box-sizing: border-box;
        box-sizing: border-box;
    }

    td {
        border-top: 1px solid #ccc;
    }

    tr:first-child > td {
        border-top: none;
    }

    .text-body {
        font-size: 9pt;
        line-height: 1.5;
    }

    .no-padding {
        padding: 0 !important;
    }

    .page-break {
        page-break-after: always !important;
    }

    .avoid-page-break {
        page-break-inside: avoid !important;
    }

    .data-request-categories-entry > caption,
    .data-request-categories > h2 {
        font-size: 11pt;
        font-weight: bold;
        text-align: left;
        padding-block: 3mm;
    }

    .data-request-categories h3 {
        background-color: #ededed;
        padding: 1.5mm 3mm;
    }

    .data-request-categories-entry-header {
        background-color: #ededed;
    }

    .data-request-categories-entry-header > td {
        padding: 10px;
    }

    .data-request-categories-entry-header-spacer {
        height: 15px;
    }

    .data-request-categories-entry {
        width: 100%;
    }

    .data-request-categories-entry ul {
        padding: 0;
        margin: 0;
    }

    .data-request-categories-entry li {
        list-style: none;
        padding: 0;
        margin: 0;
    }
</style>

<!-- Workaround to achieve full a4 format as PDF file -->
<div style="position: absolute; left: 0; top: 0; width: 210mm; background: #fff; height: 5mm; z-index: -1;"></div>
<div style="position: absolute; left: 0; top: 0; width: 5mm; background: #fff; height: 297mm; z-index: -1;"></div>

<div style="width: 210mm; padding: 5mm 15mm 5mm 10mm; webkit-box-sizing: border-box; box-sizing: border-box;">
    <h1 style="margin-bottom: 5mm;">{locale group="quiqqer/gdpr" var="DataRequest.tpl.caption"}</h1>

    <div class="data-request-info text-body">
        {locale group="quiqqer/gdpr" var="DataRequest.tpl.info"
        userName=$User->getName()
        regulatoryAuthorityAddressLines=$regulatoryAuthorityAddressLines
        date=$date
        }
    </div>

    <div class="data-request-categories-list text-body page-break">
        <p>
            {locale group="quiqqer/gdpr" var="DataRequest.tpl.categories_info"}
        </p>
        <ol>
            {foreach $providers as $entry}
                <li>{$entry['title']}</li>
            {/foreach}
        </ol>
    </div>

    <div class="data-request-categories text-body" style="width: 100%;">
        {assign var=counter value=1}
        {foreach $providers as $entry}
            <table class="data-request-categories-entry">
                <tr>
                    <td style="padding: 0 !important; border: none;">
                        <!-- User data fields -->
                        <div class="avoid-page-break">
                            <h2>
                                {$counter}. {$entry['title']}
                            </h2>

                            <h3 class="data-request-categories-entry-header">
                                {locale group="quiqqer/gdpr" var="DataRequest.tpl.header.userData"}
                            </h3>
                            <div class="data-request-categories-entry-dataFields">
                                {\QUI\GDPR\DataRequest\Utils::parseUserDataHtmlFromUserDataEntries($entry['userDataFields'])}
                            </div>
                        </div>

                        <!-- Purpose -->
                        <div class="avoid-page-break">
                            <h3 class="data-request-categories-entry-header">
                                {locale group="quiqqer/gdpr" var="DataRequest.tpl.header.purpose"}
                            </h3>
                            <div>
                                {$entry['purpose']}
                            </div>
                        </div>

                        <!-- Recipients -->
                        <div class="avoid-page-break">
                            <h3 class="data-request-categories-entry-header">
                                {locale group="quiqqer/gdpr" var="DataRequest.tpl.header.recipients"}
                            </h3>
                            <div>
                                {$entry['recipients']}
                            </div>
                        </div>

                        <!-- Storage duration -->
                        <div class="avoid-page-break">
                            <h3 class="data-request-categories-entry-header">
                                {locale group="quiqqer/gdpr" var="DataRequest.tpl.header.storageDuration"}
                            </h3>
                            <div>
                                {$entry['storageDuration']}
                            </div>
                        </div>

                        <!-- Origin -->
                        {if !empty($entry['origin'])}
                        <div class="avoid-page-break">
                            <h3 class="data-request-categories-entry-header">
                                {locale group="quiqqer/gdpr" var="DataRequest.tpl.header.origin"}
                            </h3>
                            <div>
                                {$entry['origin']}
                            </div>
                        </div>
                        {/if}

                        {if !empty($entry['customText'])}
                            <!-- Custom text -->
                        <div class="avoid-page-break">
                            <h3 class="data-request-categories-entry-header">
                                {locale group="quiqqer/gdpr" var="DataRequest.tpl.header.customText"}
                            </h3>
                            <div>
                                {$entry['customText']}
                            </div>
                        </div>
                        {/if}
                    </td>
                </tr>
            </table>

            {assign var=counter value=$counter+1}
        {/foreach}
    </div>
</div>