<?php

/**
 * @return array
 */

use QUI\GDPR\CookieManager;
use QUI\GDPR\Permissions;

QUI::$Ajax->registerFunction(
    'package_quiqqer_gdpr_ajax_getCookiesForGrid',
    function ($projectName, $projectLanguage, $page = 1, $perPage = 25, $sortOn = 'name', $sortBy = 'ASC') {
        if (!is_numeric($page) || !is_numeric($perPage)) {
            return [];
        }

        if (!in_array($sortOn, ['id', 'name', 'origin', 'purpose', 'lifetime', 'category'])) {
            $sortOn = 'eventid';
        }

        if (!in_array(strtoupper($sortBy), ['ASC', 'DESC'])) {
            $sortBy = 'ASC';
        }

        $cookieTable = CookieManager::getManualCookiesTableName(
            QUI::getProject($projectName, $projectLanguage)
        );

        $result = QUI::getDataBase()->fetch([
            'from' => $cookieTable,
            'order' => "$sortOn $sortBy"
        ]);

        return QUI\Utils\Grid::getResult($result, $page, $perPage);
    },
    ['projectName', 'projectLanguage', 'page', 'perPage', 'sortOn', 'sortBy'],
    Permissions::COOKIES_MANAGE
);
