/**
 * @module package/quiqqer/gdpr/bin/classes/ChecklistManager
 * @author www.pcsg.de (Jan Wennrich)
 */
define('package/quiqqer/gdpr/bin/classes/ChecklistManager', [
    'qui/controls/Control',
    'Ajax'
], function (QUIControl, QUIAjax) {
    "use strict";

    return new Class({
        Type: 'package/quiqqer/gdpr/bin/classes/ChecklistManager',

        Extends: QUIControl,

        /**
         * Gets the HTML form/list for the given project name
         *
         * @param projectName
         */
        getHtml: function (projectName) {
            return new Promise(function (resolve, reject) {
                QUIAjax.get('package_quiqqer_gdpr_ajax_checklist_getHtml', resolve, {
                    'package'  : 'quiqqer/gdpr',
                    onError    : reject,
                    projectName: projectName
                });
            });
        },

        saveItems: function (projectName, items) {
            return new Promise(function (resolve, reject) {
                QUIAjax.post('package_quiqqer_gdpr_ajax_checklist_saveItemValues', resolve, {
                    'package'  : 'quiqqer/gdpr',
                    onError    : reject,
                    projectName: projectName,
                    items      : JSON.encode(items)
                });
            });
        }
    });
});
