/**
 * @module package/quiqqer/gdpr/bin/controls/profile/DataRequest
 * @author www.pcsg.de (Patrick Müller)
 */
define('package/quiqqer/gdpr/bin/controls/profile/DataRequest', [

    'qui/controls/Control',
    'Ajax',
    'Locale'

    //'css!package/quiqqer/gdpr/bin/controls/profile/DataRequest.css'

], function (QUIControl, QUIAjax, QUILocale) {
    "use strict";

    var lg = 'quiqqer/gdpr';

    return new Class({
        Extends: QUIControl,
        Type   : 'package/quiqqer/gdpr/bin/controls/profile/DataRequest',

        Binds: [
            '$onImport',
            '$onClickDataRequest',
            '$onClickDeleteRequest'
        ],


        initialize: function (options) {
            this.parent(options);

            this.$Info  = null;
            this.$Error = null;

            this.addEvents({
                onImport: this.$onImport
            });
        },

        /**
         * event: onImport
         */
        $onImport: function () {
            const Elm       = this.getElm();
            const BtnData   = Elm.getElement('button[name="gdpr_request"][value="data"]');
            const BtnDelete = Elm.getElement('button[name="gdpr_request"][value="delete"]');

            /*
             * Make buttons normal buttons instead of submit buttons
             */
            BtnData.type   = 'button';
            BtnDelete.type = 'button';

            BtnData.addEvent('click', this.$onClickDataRequest);
            BtnDelete.addEvent('click', this.$onClickDeleteRequest);
        },

        /**
         * If user clicks "data request"
         *
         * @param {DocumentEvent} event
         */
        $onClickDataRequest: function (event) {
            let Btn = event.target;

            if (Btn.nodeName !== 'BUTTON') {
                Btn = Btn.getParent('button');
            }

            Btn.disabled = true;

            const BtnIcon = Btn.getElement('span');

            BtnIcon.removeClass('fa-id-card-o');
            BtnIcon.addClass('fa-spinner fa-spin');

            QUIAjax.post('package_quiqqer_gdpr_ajax_profile_gdprDataRequest', () => {
                this.$showInfo(
                    'data',
                    QUILocale.get(lg, 'profile.DataRequest.data.success')
                );

                BtnIcon.removeClass('fa-spinner fa-spin');
                BtnIcon.addClass('fa-id-card-o');
                Btn.disabled = false;
            }, {
                'package': 'quiqqer/gdpr',
                onError  : () => {
                    this.$showError(
                        'data',
                        QUILocale.get(lg, 'profile.DataRequest.data.error')
                    );

                    BtnIcon.removeClass('fa-spinner fa-spin');
                    BtnIcon.addClass('fa-id-card-o');
                    Btn.disabled = false;
                }
            });
        },

        /**
         * If user clicks "deletion request"
         *
         * @param {DocumentEvent} event
         */
        $onClickDeleteRequest: function (event) {
            let Btn = event.target;

            if (Btn.nodeName !== 'BUTTON') {
                Btn = Btn.getParent('button');
            }

            Btn.disabled = true;

            const BtnIcon = Btn.getElement('span');

            BtnIcon.removeClass('fa-trash');
            BtnIcon.addClass('fa-spinner fa-spin');

            QUIAjax.post('package_quiqqer_gdpr_ajax_profile_gdprDeleteRequest', () => {
                this.$showInfo(
                    'delete',
                    QUILocale.get(lg, 'profile.DataRequest.delete.success')
                );

                BtnIcon.removeClass('fa-spinner fa-spin');
                BtnIcon.addClass('fa-trash');
                Btn.disabled = false;
            }, {
                'package': 'quiqqer/gdpr',
                onError  : () => {
                    this.$showError(
                        'delete',
                        QUILocale.get(lg, 'profile.DataRequest.delete.error')
                    );

                    BtnIcon.removeClass('fa-spinner fa-spin');
                    BtnIcon.addClass('fa-trash');
                    Btn.disabled = false;
                }
            });
        },

        /**
         * Show info message
         *
         * @param {String} area
         * @param {String} msg
         */
        $showInfo: function (area, msg) {
            if (this.$Info) {
                this.$Info.destroy();
            }

            let TargetParent;

            switch (area) {
                case 'data':
                    TargetParent = this.getElm().getElement('.quiqqer-gdpr-profile-data-message');
                    break;

                default:
                    TargetParent = this.getElm().getElement('.quiqqer-gdpr-profile-delete-message');
            }

            this.$Info = new Element('div', {
                'class': 'content-message-information',
                html   : msg
            }).inject(TargetParent);
        },

        /**
         * Show error message
         *
         * @param {String} area
         * @param {String} msg
         */
        $showError: function (area, msg) {
            if (this.$Info) {
                this.$Info.destroy();
            }

            let TargetParent;

            switch (area) {
                case 'data':
                    TargetParent = this.getElm().getElement('.quiqqer-gdpr-profile-data-message');
                    break;

                default:
                    TargetParent = this.getElm().getElement('.quiqqer-gdpr-profile-delete-message');
            }

            this.$Info = new Element('div', {
                'class': 'content-message-error',
                html   : msg
            }).inject(TargetParent);
        }
    });
});
