<?php

/**
 * This file contains package_quiqqer_dashboard_ajax_backend_getLatestLogins
 */

use QUI\LoginLogger\LoginLogger;

/**
 * Returns the latest logins for the dashboard card
 *
 * @return array
 */
QUI::$Ajax->registerFunction(
    'package_quiqqer_login-logger_ajax_getLatestLogins',
    function () {
        return LoginLogger::getLogins([
            'select' => 'uid, username, ip, date, successful, type',
            'limit'  => 10,
            'order'  => 'date DESC'
        ]);
    },
    false,
    'Permission::checkAdminUser'
);
