/**
 * @module package/quiqqer/login-logger/bin/controls/DashboardCards/LatestLogins
 *
 * @author www.pcsg.de (Jan Wennrich)
 * @author www.pcsg.de (Henning Leutz)
 */
define('package/quiqqer/login-logger/bin/controls/DashboardCards/LatestLogins', [

    'Ajax',
    'Locale',
    'Mustache',

    'package/quiqqer/dashboard/bin/backend/controls/Card',
    'package/quiqqer/login-logger/bin/classes/Utils',

    'text!package/quiqqer/login-logger/bin/controls/DashboardCards/LatestLogins.html'

], function (QUIAjax, QUILocale, Mustache, QUICard, UtilsClass, template) {
    "use strict";

    var lg = 'quiqqer/login-logger';

    var Utils = new UtilsClass();

    return new Class({

        Extends: QUICard,
        Type   : 'package/quiqqer/login-logger/bin/controls/DashboardCards/LatestLogins',

        Binds: [
            '$onCreate'
        ],

        initialize: function (options) {
            this.parent(options);

            this.setAttributes({
                id      : 'quiqqer-dashboard-card-latest-logins',
                icon    : 'fa fa-sign-in',
                title   : QUILocale.get('quiqqer/login-logger', 'dashboard.card.lastlogins.title'),
                content : Mustache.render(template, {
                    date      : QUILocale.get(lg, 'table.header.date'),
                    username  : QUILocale.get(lg, 'table.header.username'),
                    ip        : QUILocale.get(lg, 'table.header.ip'),
                    successful: QUILocale.get(lg, 'table.header.successful'),
                    type      : QUILocale.get(lg, 'table.header.type')
                }),
                footer  : false,
                priority: 70
            });

            this.addEvents({
                onCreate: this.$onCreate
            });
        },

        $onCreate: function () {
            this.$Content.addClass('card-table');
            this.$Content.removeClass('card-body');

            this.getElm().classList.add('col-sm-6');
            this.getElm().classList.add('col-lg-6');
        },

        refresh: function () {
            var self = this;

            QUIAjax.get('package_quiqqer_login-logger_ajax_getLatestLogins', function (result) {
                result = Utils.convertSuccessStatusToIconElement(result);

                self.getElm().addEvent('click', function () {
                    window.parent.require([
                        'utils/Panels',
                        'package/quiqqer/login-logger/bin/controls/Panel'
                    ], function (PanelUtils, LoginLoggerPanel) {
                        PanelUtils.openPanelInTasks(new LoginLoggerPanel());
                    });
                });

                var Tbody = self.getElm().getElement('tbody');

                for (var i = 0, len = result.length; i < len; i++) {
                    var entry = result[i];

                    new Element('tr', {
                        'data-uid': entry.uid,
                        html      : '' +
                            '<td>' + entry.date + '</td>' +
                            '<td>' + entry.username + '</td>' +
                            '<td>' + entry.ip + '</td>' +
                            '<td style="text-align: center">' + entry.successful.outerHTML + '</td>' +
                            '<td>' + entry.type + '</td>'
                    }).inject(Tbody);
                }
            }, {
                'package': 'quiqqer/login-logger',
                onError  : console.error
            });
        }
    });
});
